/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.lang.pool;

import com.tplus.transform.lang.ObjectFactory;
import com.tplus.transform.lang.ObjectPool;
import java.util.concurrent.ConcurrentLinkedQueue;

public class ObjectPoolImpl
implements ObjectPool {
    ObjectFactory objectFactory;
    ConcurrentLinkedQueue<Object> freePool = new ConcurrentLinkedQueue();
    int maxPoolSize = Integer.MAX_VALUE;
    int maxWaitTime = 0;
    int exhaustPolicy = 0;
    int objectCount;

    public ObjectPoolImpl(ObjectFactory objectFactory) {
        this.objectFactory = objectFactory;
    }

    public int getFreeObjectCount() {
        return this.freePool.size();
    }

    public int getObjectCount() {
        return this.objectCount;
    }

    public Object createObjectNoPool() throws IllegalAccessException, InstantiationException {
        Object newObj = this.objectFactory.create();
        return newObj;
    }

    public Object getObjectFromPool() throws IllegalAccessException, InstantiationException {
        Object obj = this.getFreeObjectFromPool();
        if (obj == null) {
            obj = this.createOrWaitForObject();
        }
        return obj;
    }

    public void releaseObjectToPool(Object actualObject) {
        this.freePool.offer(actualObject);
    }

    private Object getFreeObjectFromPool() {
        return this.freePool.poll();
    }

    private Object createOrWaitForObject() throws InstantiationException, IllegalAccessException {
        if (this.getObjectCount() >= this.maxPoolSize) {
            throw new RuntimeException("pool exhausted");
        }
        Object obj = this.createNewObject();
        return obj;
    }

    private Object createNewObject() throws InstantiationException, IllegalAccessException {
        Object newObj = this.objectFactory.create();
        ++this.objectCount;
        return newObj;
    }

    public void ensureCapacity(int capacity) throws InstantiationException, IllegalAccessException {
    }

    public void invalidateObject(Object object) throws Exception {
    }

    public int getMaxPoolSize() {
        return this.maxPoolSize;
    }

    public void setMaxPoolSize(int maxPoolSize) {
        this.maxPoolSize = maxPoolSize;
    }

    public int getMaxWaitTime() {
        return this.maxWaitTime;
    }

    public void setMaxWaitTime(int maxWaitTime) {
        this.maxWaitTime = maxWaitTime;
    }

    public int getExhaustPolicy() {
        return this.exhaustPolicy;
    }

    public void setExhaustPolicy(int exhaustPolicy) {
        this.exhaustPolicy = exhaustPolicy;
    }
}

