/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.security.codec;

import com.tplus.transform.lang.Wrapper;
import com.tplus.transform.security.codec.Codec;
import com.tplus.transform.security.codec.PushbackString;
import java.util.Arrays;

public abstract class AbstractCodec
implements Codec {
    private static final char[] EMPTY_CHAR_ARRAY = new char[0];

    private static final boolean contains(char[] array, char c) {
        if (array == null) {
            return false;
        }
        for (int i = 0; i < array.length; ++i) {
            if (array[i] != c) continue;
            return true;
        }
        return false;
    }

    public static final boolean containsCharacter(Character c, char[] array) {
        return AbstractCodec.contains(array, c.charValue());
    }

    protected static final boolean sortedContains(char[] array, char c) {
        if (array == null) {
            return false;
        }
        return Arrays.binarySearch(array, c) >= 0;
    }

    protected static final char[] copyAndSort(char[] array) {
        if (array == null || array.length <= 0) {
            return EMPTY_CHAR_ARRAY;
        }
        char[] ret = new char[array.length];
        for (int i = 0; i < array.length; ++i) {
            ret[i] = array[i];
        }
        Arrays.sort(ret);
        return ret;
    }

    public String decode(String input) {
        StringBuffer sb = new StringBuffer();
        PushbackString pbs = new PushbackString(input);
        while (pbs.hasNext()) {
            Character c = this.decodeCharacter(pbs);
            if (c != null) {
                sb.append(c);
                continue;
            }
            sb.append(pbs.next());
        }
        return sb.toString();
    }

    public String encodeCharacter(Character c) {
        return this.encodeCharacter(EMPTY_CHAR_ARRAY, c);
    }

    public String encodeCharacter(char[] immune, Character c) {
        if (AbstractCodec.contains(immune, c.charValue())) {
            return c.toString();
        }
        return this.encodeCharacter(c);
    }

    public String encode(char[] immune, String input) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < input.length(); ++i) {
            sb.append(this.encodeCharacter(immune, Wrapper.box(input.charAt(i))));
        }
        return sb.toString();
    }

    public String encode(String input) {
        return this.encode(EMPTY_CHAR_ARRAY, input);
    }
}

