/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.util;

import com.tplus.transform.util.ExecUtil;
import com.tplus.transform.util.ExecutableCommand;
import com.tplus.transform.util.MessageListener;
import com.tplus.transform.util.StringUtils;
import com.tplus.transform.util.TaskDisplayer;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public abstract class AbstractExecutableCommand
implements ExecutableCommand {
    protected String initialDir;
    protected boolean showInformativeMessage = true;
    PrintWriter outputWriter = new PrintWriter(System.out);
    PrintWriter errorWriter = new PrintWriter(System.err);
    private String commandName;
    private boolean executing;
    protected TaskDisplayer taskListener;
    protected List args = new ArrayList();

    public void setInitialDir(String initialDir) {
        this.initialDir = initialDir;
    }

    public void setOutputWriter(PrintWriter outputWriter) {
        this.outputWriter = outputWriter;
    }

    public void setErrorWriter(PrintWriter errorWriter) {
        this.errorWriter = errorWriter;
    }

    public PrintWriter getOutputWriter() {
        return this.outputWriter;
    }

    public PrintWriter getErrorWriter() {
        return this.errorWriter;
    }

    public void setShowInformativeMessage(boolean showInformativeMessage) {
        this.showInformativeMessage = showInformativeMessage;
    }

    public final int execute(MessageListener listener) {
        this.setErrorWriter(listener.getErrorWriter());
        this.setOutputWriter(listener.getOutputWriter());
        return this.execute();
    }

    public final Object run(TaskDisplayer taskListener) {
        this.taskListener = taskListener;
        int toRet = this.executeImpl();
        return new Integer(toRet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int executeImpl() {
        this.executing = true;
        try {
            int n = this.execute();
            return n;
        }
        finally {
            this.executing = false;
        }
    }

    public final int execute(PrintWriter out, PrintWriter err) {
        this.setErrorWriter(err);
        this.setOutputWriter(out);
        return this.executeImpl();
    }

    public void setCommand(String command) {
    }

    public void addArg(String arg) {
        this.args.add(arg);
    }

    public void addArgs(String[] arg) {
        this.args.addAll(Arrays.asList(arg));
    }

    public List getArgs() {
        return this.args;
    }

    public void stop() {
    }

    public boolean isExecuting() {
        return this.executing;
    }

    public void setOption(String name, String value) {
    }

    public int getMaxCommandLineLimit() {
        return Integer.MAX_VALUE;
    }

    protected void showCommandLine(String[] exec) {
        String command = this.getCommandName();
        PrintWriter out = this.getOutputWriter();
        out.print(command);
        out.println(ExecUtil.prepareCommandLineDisplayString(exec));
    }

    protected String getCommandName() {
        if (this.commandName == null) {
            return StringUtils.rightStr(this.getClass().getName(), ".");
        }
        return this.commandName;
    }

    public void setCommandName(String commandName) {
        this.commandName = commandName;
    }
}

