/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.util;

import com.tplus.transform.util.HomeUtils;
import com.tplus.transform.util.IOUtil;
import com.tplus.transform.util.io.FileUtil;
import java.io.File;

public class ApplicationUtils {
    static boolean firstCall = true;
    private static String appTempDir;

    public static void setTempDirectory(String appTempDir) {
        ApplicationUtils.appTempDir = appTempDir;
    }

    public static synchronized String getInstanceTempDir(String appIdentity) {
        String tempDir = ApplicationUtils.getTempDir();
        String instanceName = ApplicationUtils.getInstanceName(appIdentity);
        File volanteDir = new File(tempDir, instanceName);
        FileUtil.mkdirs(volanteDir);
        if (firstCall) {
            IOUtil.delChildren(volanteDir);
            firstCall = false;
        }
        return volanteDir.getAbsolutePath();
    }

    public static String getTempDir() {
        return appTempDir == null ? System.getProperty("java.io.tmpdir") : appTempDir;
    }

    public static String getInstanceTempDir(String subDir, String appIdentity) {
        File instancdDir = new File(ApplicationUtils.getInstanceTempDir(appIdentity), subDir);
        FileUtil.mkdirs(instancdDir);
        return instancdDir.getAbsolutePath();
    }

    public static void cleanInstanceTempDir(String subDir, String appIdentity) {
        IOUtil.delDir(new File(ApplicationUtils.getInstanceTempDir(subDir, appIdentity)));
    }

    public static void cleanInstance(String subDir, String appIdentity) {
        IOUtil.delDir(new File(ApplicationUtils.getInstanceTempDir(subDir, appIdentity)));
    }

    private static String getInstanceName(String appIdentity) {
        String designerHomeDir = HomeUtils.getHome(appIdentity);
        int instanceIdentity = Math.abs(designerHomeDir.hashCode());
        String instanceName = appIdentity + instanceIdentity;
        return instanceName;
    }
}

