/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.util;

import com.tplus.transform.lang.FastStringBuffer;
import com.tplus.transform.lang.Wrapper;
import com.tplus.transform.util.CalendarParser;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public final class CalendarFormatter {
    public static String format(String format, Date date) throws IllegalArgumentException {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        return CalendarFormatter.format(format, cal);
    }

    public static String format(String format, Calendar cal) throws IllegalArgumentException {
        int fidx = 0;
        int flen = format.length();
        FastStringBuffer buf = new FastStringBuffer(25);
        block9: while (fidx < flen) {
            char fch;
            if ((fch = format.charAt(fidx++)) != '%') {
                buf.append(fch);
                continue;
            }
            switch (format.charAt(fidx++)) {
                case 'Y': {
                    CalendarFormatter.formatYear(cal, buf);
                    continue block9;
                }
                case 'M': {
                    CalendarFormatter.formatMonth(cal, buf);
                    continue block9;
                }
                case 'D': {
                    CalendarFormatter.formatDays(cal, buf);
                    continue block9;
                }
                case 'h': {
                    CalendarFormatter.formatHours(cal, buf);
                    continue block9;
                }
                case 'm': {
                    CalendarFormatter.formatMinutes(cal, buf);
                    continue block9;
                }
                case 's': {
                    CalendarFormatter.formatSeconds(cal, buf);
                    continue block9;
                }
                case 'z': {
                    CalendarFormatter.formatTimeZone(cal, buf);
                    continue block9;
                }
            }
            throw new IllegalArgumentException("Illegal meta character");
        }
        return buf.toString();
    }

    private static void formatYear(Calendar cal, FastStringBuffer buf) {
        int year = cal.get(1);
        int era = cal.get(0);
        String s = Integer.toString(year);
        while (s.length() < 4) {
            s = '0' + s;
        }
        if (era == 0) {
            s = '-' + s;
        }
        buf.append(s);
    }

    private static void formatMonth(Calendar cal, FastStringBuffer buf) {
        CalendarFormatter.formatTwoDigits(cal.get(2) + 1, buf);
    }

    private static void formatDays(Calendar cal, FastStringBuffer buf) {
        CalendarFormatter.formatTwoDigits(cal.get(5), buf);
    }

    private static void formatHours(Calendar cal, FastStringBuffer buf) {
        CalendarFormatter.formatTwoDigits(cal.get(11), buf);
    }

    private static void formatMinutes(Calendar cal, FastStringBuffer buf) {
        CalendarFormatter.formatTwoDigits(cal.get(12), buf);
    }

    private static void formatSeconds(Calendar cal, FastStringBuffer buf) {
        int n;
        CalendarFormatter.formatTwoDigits(cal.get(13), buf);
        if (cal.isSet(14) && (n = cal.get(14)) != 0) {
            String ms = Wrapper.toString(n);
            while (ms.length() < 3) {
                ms = '0' + ms;
            }
            buf.append('.');
            buf.append(ms);
        }
    }

    public static void formatTimeZone(Calendar cal, FastStringBuffer buf) {
        TimeZone tz = cal.getTimeZone();
        if (tz == CalendarParser.DEFAULT_TIMEZONE) {
            return;
        }
        if (tz.getRawOffset() == 0) {
            buf.append('Z');
            return;
        }
        int offset = tz.inDaylightTime(cal.getTime()) ? tz.getRawOffset() + (tz.useDaylightTime() ? 3600000 : 0) : tz.getRawOffset();
        if (offset >= 0) {
            buf.append('+');
        } else {
            buf.append('-');
            offset *= -1;
        }
        CalendarFormatter.formatTwoDigits((offset /= 60000) / 60, buf);
        buf.append(':');
        CalendarFormatter.formatTwoDigits(offset % 60, buf);
    }

    private static final void formatTwoDigits(int n, FastStringBuffer buf) {
        buf.append((char)(48 + n / 10));
        buf.append((char)(48 + n % 10));
    }
}

