/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.util;

import com.tplus.transform.util.SequencedHashMap;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Set;

public abstract class EnumObject
implements Comparable,
Serializable {
    String name;
    int ordinal;
    private static final long serialVersionUID = 1L;

    protected EnumObject(String name) {
        this.init(name, this.getEnumClassObjectInfo().getNextOrdinal());
    }

    protected EnumObject(String name, int ordinal) {
        this.init(name, ordinal);
    }

    private void init(String name, int ordinal) {
        if (name == null) {
            throw new NullPointerException("The name of enum cannot be null");
        }
        this.name = name;
        this.ordinal = ordinal;
        this.addObject(this);
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    public int getOrdinal() {
        return this.ordinal;
    }

    public final int hashCode() {
        return super.hashCode();
    }

    public final boolean equals(Object obj) {
        return this == obj;
    }

    public final boolean equals(EnumObject obj) {
        return this == obj;
    }

    public final boolean equals(String obj) {
        return false;
    }

    public final int compareTo(Object o) {
        EnumObject other = (EnumObject)o;
        EnumObject self = this;
        if (self.getClass() != other.getClass() && self.getDeclaringClass() != other.getDeclaringClass()) {
            throw new ClassCastException();
        }
        return self.ordinal - other.ordinal;
    }

    public final Class getDeclaringClass() {
        Class<?> clazz = this.getClass();
        Class<?> zuper = clazz.getSuperclass();
        while (zuper != EnumObject.class) {
            clazz = zuper;
            zuper = clazz.getSuperclass();
        }
        return zuper == EnumObject.class ? clazz : zuper;
    }

    protected final Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    protected Object readResolve() throws ObjectStreamException {
        return this.getEnumClassObjectInfo().valueOf(this.getName());
    }

    private void addObject(EnumObject obj) {
        this.getEnumClassObjectInfo().add(obj);
    }

    protected abstract EnumClassObjectInfo getEnumClassObjectInfo();

    protected static class EnumClassObjectInfo {
        SequencedHashMap objectMap = new SequencedHashMap();
        Class classToken;
        private Object[] valuesCache;

        public EnumClassObjectInfo(Class classToken) {
            this.classToken = classToken;
        }

        void add(EnumObject obj) {
            if (this.objectMap.containsKey(obj.getName())) {
                throw new IllegalArgumentException("Duplicate enum name " + obj.getName());
            }
            this.objectMap.put(obj.getName(), obj);
        }

        public Object[] values() {
            if (this.valuesCache == null) {
                this.valuesCache = this.values0();
            }
            return this.valuesCache;
        }

        private Object[] values0() {
            Collection values = this.objectMap.values();
            return values.toArray((Object[])Array.newInstance(this.classToken, values.size()));
        }

        public String[] names() {
            Set nameSet = this.objectMap.keySet();
            return nameSet.toArray(new String[nameSet.size()]);
        }

        public EnumObject valueOf(String name) {
            EnumObject obj = (EnumObject)this.objectMap.get(name);
            if (obj == null) {
                throw new IllegalArgumentException("No constant with name " + name + ". Expected one of " + this.objectMap.keySet());
            }
            return obj;
        }

        public EnumObject valueOf(String name, EnumObject defaultValue) {
            EnumObject obj = (EnumObject)this.objectMap.get(name);
            if (obj == null) {
                return defaultValue;
            }
            return obj;
        }

        public EnumObject valueOf(int ordinal) {
            for (EnumObject obj : this.objectMap.values()) {
                if (obj.getOrdinal() != ordinal) continue;
                return obj;
            }
            throw new IllegalArgumentException("No constant with ordinal value " + ordinal);
        }

        public int getNextOrdinal() {
            if (this.objectMap.size() > 0) {
                EnumObject obj = (EnumObject)this.objectMap.getValue(this.objectMap.size() - 1);
                return obj.getOrdinal() + 1;
            }
            return 0;
        }

        public boolean contains(String elementType) {
            return this.objectMap.containsKey(elementType);
        }
    }
}

