/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.util;

import com.tplus.transform.util.ApplicationProps;
import com.tplus.transform.util.IOUtil;
import com.tplus.transform.util.io.FileUtil;
import java.io.File;
import java.util.Properties;

public class HomeUtils {
    public static final String DESIGNER = "designer";
    private static final String VOLANTE_PROJECTS = "Volante Projects";
    public static final String HOME_EXT = ".home";
    public static final String USER_HOME_EXT = ".user.home";
    public static final String CONFIG_EXT = ".config";
    public static final String USER_CONFIG_EXT = ".user.config";
    static Properties properties = new Properties();

    public static String getHome(String name) {
        String key = name + HOME_EXT;
        return HomeUtils.getValue(key);
    }

    public static String getUserHome(String appName) {
        String userHome = HomeUtils.getValue(appName + USER_HOME_EXT);
        if (userHome == null) {
            userHome = HomeUtils.getHome(appName);
        }
        return userHome;
    }

    public static String getConfig(String appName) {
        String config = HomeUtils.getValue(appName + CONFIG_EXT);
        if (config == null) {
            config = new File(HomeUtils.getUserHome(appName), "config").getPath();
        }
        return config;
    }

    public static String getUserConfig(String appName) {
        String userConfig = HomeUtils.getValue(appName + USER_CONFIG_EXT);
        if (userConfig == null) {
            userConfig = HomeUtils.getConfig(appName);
        }
        return userConfig;
    }

    public static void setHomes(String appName) {
        ApplicationProps.readApplicationProperties(appName);
        String home = HomeUtils.getHome(appName);
        HomeUtils.setHomes(appName, home);
    }

    public static void setHomes(String appName, String home) {
        HomeUtils.setValue(appName + HOME_EXT, HomeUtils.getCanonicalName(home));
        HomeUtils.setValue(appName + USER_HOME_EXT, HomeUtils.getCanonicalName(HomeUtils.getUserHome(appName)));
        HomeUtils.setValue(appName + CONFIG_EXT, HomeUtils.getCanonicalName(HomeUtils.getConfig(appName)));
        HomeUtils.setValue(appName + USER_CONFIG_EXT, HomeUtils.getCanonicalName(HomeUtils.getUserConfig(appName)));
    }

    public static void clearHomes(String appName) {
        HomeUtils.clearValue(appName + HOME_EXT);
        HomeUtils.clearValue(appName + USER_HOME_EXT);
        HomeUtils.clearValue(appName + CONFIG_EXT);
        HomeUtils.clearValue(appName + USER_CONFIG_EXT);
    }

    public static String getUserProjectsDir(String appName) {
        File file;
        String userDir = System.getProperty("user.dir");
        if (userDir == null) {
            userDir = HomeUtils.getHome(appName);
        }
        if (!(file = new File(userDir, VOLANTE_PROJECTS)).exists()) {
            FileUtil.mkdirs(file);
        }
        return file.getAbsolutePath();
    }

    private static String getCanonicalName(String fileName) {
        try {
            fileName = IOUtil.canonicalize(fileName);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return fileName;
    }

    private static String getValue(String key) {
        String property = properties.getProperty(key);
        if (property == null) {
            property = System.getProperty(key);
        }
        return property;
    }

    private static void setValue(String key, String value) {
        if (value != null) {
            properties.setProperty(key, value);
            System.setProperty(key, value);
        } else {
            HomeUtils.clearValue(key);
        }
    }

    private static void clearValue(String key) {
        properties.remove(key);
        System.clearProperty(key);
    }
}

