/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.util;

import com.tplus.transform.util.IntHashMapEntry;
import com.tplus.transform.util.IntHashMapEnumerator;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;

public class IntHashMap
implements Cloneable,
Serializable {
    private transient IntHashMapEntry[] table;
    private transient int count;
    private int threshold;
    private float loadFactor;
    private static final long serialVersionUID = 1421746759512286392L;

    public IntHashMap(int initialCapacity, float loadFactor) {
        if (initialCapacity <= 0 || (double)loadFactor <= 0.0) {
            throw new IllegalArgumentException();
        }
        this.loadFactor = loadFactor;
        this.table = new IntHashMapEntry[initialCapacity];
        this.threshold = (int)((float)initialCapacity * loadFactor);
    }

    public IntHashMap(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public IntHashMap() {
        this(101, 0.75f);
    }

    public int size() {
        return this.count;
    }

    public boolean isEmpty() {
        return this.count == 0;
    }

    public Enumeration keys() {
        return new IntHashMapEnumerator(this.table, true);
    }

    public Enumeration elements() {
        return new IntHashMapEnumerator(this.table, false);
    }

    public boolean contains(Object value) {
        if (value == null) {
            throw new NullPointerException();
        }
        IntHashMapEntry[] tab = this.table;
        int i = tab.length;
        while (i-- > 0) {
            IntHashMapEntry e = tab[i];
            while (e != null) {
                if (e.value.equals(value)) {
                    return true;
                }
                e = e.next;
            }
        }
        return false;
    }

    public boolean containsKey(int key) {
        IntHashMapEntry[] tab = this.table;
        int index = (key & Integer.MAX_VALUE) % tab.length;
        IntHashMapEntry e = tab[index];
        while (e != null) {
            if (e.key == key) {
                return true;
            }
            e = e.next;
        }
        return false;
    }

    public Object get(int key) {
        IntHashMapEntry[] tab = this.table;
        int index = (key & Integer.MAX_VALUE) % tab.length;
        IntHashMapEntry e = tab[index];
        while (e != null) {
            if (e.key == key) {
                return e.value;
            }
            e = e.next;
        }
        return null;
    }

    protected void rehash() {
        int oldCapacity = this.table.length;
        IntHashMapEntry[] oldTable = this.table;
        int newCapacity = oldCapacity * 2 + 1;
        IntHashMapEntry[] newTable = new IntHashMapEntry[newCapacity];
        this.threshold = (int)((float)newCapacity * this.loadFactor);
        this.table = newTable;
        int i = oldCapacity;
        while (i-- > 0) {
            IntHashMapEntry old = oldTable[i];
            while (old != null) {
                IntHashMapEntry e = old;
                old = old.next;
                int index = (e.key & Integer.MAX_VALUE) % newCapacity;
                e.next = newTable[index];
                newTable[index] = e;
            }
        }
    }

    public Object put(int key, Object value) {
        if (value == null) {
            throw new NullPointerException();
        }
        IntHashMapEntry[] tab = this.table;
        int index = (key & Integer.MAX_VALUE) % tab.length;
        IntHashMapEntry e = tab[index];
        while (e != null) {
            if (e.key == key) {
                Object old = e.value;
                e.value = value;
                return old;
            }
            e = e.next;
        }
        if (this.count >= this.threshold) {
            this.rehash();
            return this.put(key, value);
        }
        e = new IntHashMapEntry();
        e.key = key;
        e.value = value;
        e.next = tab[index];
        tab[index] = e;
        ++this.count;
        return null;
    }

    public Object remove(int key) {
        IntHashMapEntry[] tab = this.table;
        int index = (key & Integer.MAX_VALUE) % tab.length;
        IntHashMapEntry e = tab[index];
        IntHashMapEntry prev = null;
        while (e != null) {
            if (e.key == key) {
                if (prev != null) {
                    prev.next = e.next;
                } else {
                    tab[index] = e.next;
                }
                --this.count;
                return e.value;
            }
            prev = e;
            e = e.next;
        }
        return null;
    }

    public void clear() {
        IntHashMapEntry[] tab = this.table;
        int index = tab.length;
        while (--index >= 0) {
            tab[index] = null;
        }
        this.count = 0;
    }

    public Object clone() {
        try {
            IntHashMap t = (IntHashMap)super.clone();
            t.table = new IntHashMapEntry[this.table.length];
            int i = this.table.length;
            while (i-- > 0) {
                t.table[i] = this.table[i] != null ? (IntHashMapEntry)this.table[i].clone() : null;
            }
            return t;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public String toString() {
        int max = this.size() - 1;
        StringBuffer buf = new StringBuffer();
        Enumeration k = this.keys();
        Enumeration e = this.elements();
        buf.append("{");
        for (int i = 0; i <= max; ++i) {
            String s1 = k.nextElement().toString();
            String s2 = e.nextElement().toString();
            buf.append(s1 + "=" + s2);
            if (i >= max) continue;
            buf.append(", ");
        }
        buf.append("}");
        return buf.toString();
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeInt(this.table.length);
        s.writeInt(this.count);
        for (int index = this.table.length - 1; index >= 0; --index) {
            IntHashMapEntry entry = this.table[index];
            while (entry != null) {
                s.writeInt(entry.key);
                s.writeObject(entry.value);
                entry = entry.next;
            }
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        int origlength = s.readInt();
        int elements = s.readInt();
        int length = (int)((float)elements * this.loadFactor) + elements / 20 + 3;
        if (length > elements && (length & 1) == 0) {
            --length;
        }
        if (origlength > 0 && length > origlength) {
            length = origlength;
        }
        this.table = new IntHashMapEntry[length];
        this.count = 0;
        while (elements > 0) {
            int key = s.readInt();
            Object value = s.readObject();
            this.put(key, value);
            --elements;
        }
    }

    public static void cmtmain(String[] args) {
        System.out.println("testing 150,000 hash table entries with old hash table");
        IntHashMap.timestamp();
        Hashtable<Integer, Object> ht = new Hashtable<Integer, Object>();
        Object o = new Object();
        for (int i = 0; i < 150000; ++i) {
            ht.put(new Integer(i), o);
        }
        IntHashMap.timestamp();
        ht = null;
        System.gc();
        System.out.println("testing 150,000 hash table entries with new hash table");
        IntHashMap.timestamp();
        IntHashMap it = new IntHashMap();
        for (int i = 0; i < 150000; ++i) {
            it.put(i, o);
        }
        IntHashMap.timestamp();
    }

    private static void timestamp() {
        Date d = new Date(System.currentTimeMillis());
        SimpleDateFormat df = new SimpleDateFormat("hh:mm:ss");
        System.out.println(df.format(d));
    }
}

