/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;

public class JavaPrettyPrinter
extends BufferedWriter {
    private int lineNumber = 0;
    private int column = 0;
    int INDENT_SIZE = 4;
    int MAX_COLS_PER_LINE = 1000;
    private boolean skipLF;
    int indent = 0;
    private boolean newLine = true;
    boolean inString = false;
    private int previousChar;

    public JavaPrettyPrinter(Writer out) {
        super(out);
    }

    public void setLineNumber(int lineNumber) {
        this.lineNumber = lineNumber;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public void write(int c) throws IOException {
        this.write0(c);
        this.previousChar = c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write0(int c) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.skipLF) {
                this.skipLF = false;
                ++this.lineNumber;
                this.newLine = true;
                this.column = 0;
                this.inString = false;
                if (c == 10) {
                    this.superWrite(c);
                    return;
                }
            }
            if (!(this.column <= this.MAX_COLS_PER_LINE - 50 || c != 40 && c != 41 && c != 44 || this.inString)) {
                this.superWrite(13);
                this.superWrite(10);
                super.write("    ");
                this.newLine = true;
                this.column = 0;
            }
            switch (c) {
                case 34: {
                    if (this.inString && this.previousChar == 92) break;
                    this.inString = !this.inString;
                    break;
                }
                case 13: {
                    this.skipLF = true;
                    this.superWrite(c);
                    return;
                }
                case 10: {
                    ++this.lineNumber;
                    this.column = 0;
                    this.newLine = true;
                    this.inString = false;
                    this.column = 0;
                    this.superWrite(c);
                    return;
                }
            }
            if (c == 125) {
                --this.indent;
            }
            if (this.newLine) {
                if (Character.isWhitespace((char)c)) {
                    return;
                }
                int indentLength = this.indent * this.INDENT_SIZE;
                indentLength %= 100;
                for (int i = 0; i < indentLength; ++i) {
                    this.superWrite(32);
                    ++this.column;
                }
                this.newLine = false;
            }
            if (c == 123) {
                ++this.indent;
            }
            ++this.column;
            this.superWrite(c);
        }
    }

    private void superWrite(int c) throws IOException {
        if (c > 127) {
            String toWrite = "\\u" + JavaPrettyPrinter.padZero(Integer.toString(c, 16), 4);
            for (int i = 0; i < toWrite.length(); ++i) {
                super.write(toWrite.charAt(i));
            }
        } else {
            super.write(c);
        }
    }

    private static String padZero(String str, int maxLength) {
        StringBuffer toRet = new StringBuffer(str);
        while (toRet.length() < maxLength) {
            toRet.insert(0, '0');
        }
        return toRet.toString();
    }

    public void write(char[] cbuf) throws IOException {
        this.write(cbuf, 0, cbuf.length);
    }

    public void write(char[] cbuf, int off, int len) throws IOException {
        for (int i = off; i < off + len; ++i) {
            this.write(cbuf[i]);
        }
    }

    public void write(String str) throws IOException {
        this.write(str, 0, str.length());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(String str, int off, int len) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            char[] cbuf = new char[len];
            str.getChars(off, off + len, cbuf, 0);
            this.write(cbuf, 0, len);
        }
    }

    public static void cmtmain(String[] args) throws Exception {
        String fileName = args[0];
        BufferedReader reader = new BufferedReader(new FileReader(fileName));
        PrintWriter writer = new PrintWriter(new JavaPrettyPrinter(new FileWriter("Prety" + fileName)));
        String line = null;
        while ((line = reader.readLine()) != null) {
            writer.println(line);
        }
        writer.flush();
    }
}

