/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.util;

import com.tplus.transform.util.FileWriterBase;
import com.tplus.transform.util.io.FileUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;

public class MirrorFileWriter
extends FileWriterBase {
    String fileName;
    String mirrorFileName;
    boolean open;
    private boolean alwaysWrite;
    public static final boolean DO_NOT_MIRROR = false;

    public MirrorFileWriter(String fileName) throws IOException {
        super(MirrorFileWriter.getMirrorFileInfo((String)fileName).mirrorFileName);
        this.fileName = fileName;
        this.mirrorFileName = this.getFileWriterFileName();
        this.open = true;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.open) {
            // empty if block
        }
    }

    public void close() throws IOException {
        super.close();
        this.open = false;
        if (!this.fileName.equals(this.mirrorFileName)) {
            if (this.alwaysWrite || MirrorFileWriter.diff(this.fileName, this.mirrorFileName)) {
                File actualFile = new File(this.fileName);
                actualFile.delete();
                new File(this.mirrorFileName).renameTo(actualFile);
            } else {
                new File(this.mirrorFileName).delete();
            }
        }
        FileUtil.elevateFileUserPermission(this.fileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean checkDiff(String fileName1, String fileName2) throws Exception {
        long l2;
        long l1 = new File(fileName1).length();
        if (l1 != (l2 = new File(fileName2).length())) {
            return true;
        }
        FileReader fis1 = new FileReader(fileName1);
        FileReader fis2 = new FileReader(fileName2);
        try {
            BufferedReader br1 = new BufferedReader(fis1);
            BufferedReader br2 = new BufferedReader(fis2);
            int i = 1;
            while (true) {
                String line1 = br1.readLine();
                String line2 = br2.readLine();
                if (line1 == null && line2 == null) {
                    break;
                }
                if (line1 == null) {
                    boolean bl = true;
                    return bl;
                }
                if (line2 == null) {
                    boolean bl = true;
                    return bl;
                }
                if (!line1.equals(line2)) {
                    boolean bl = true;
                    return bl;
                }
                ++i;
            }
        }
        finally {
            fis1.close();
            fis2.close();
        }
        return false;
    }

    public static boolean diff(String fileName1, String fileName2) {
        try {
            return MirrorFileWriter.checkDiff(fileName1, fileName2);
        }
        catch (Exception e) {
            return true;
        }
    }

    static MirrorFileInfo getMirrorFileInfo(String fileName) {
        MirrorFileInfo mirrorFileInfo = new File(fileName).exists() ? new MirrorFileInfo(fileName, fileName + ".mirror") : new MirrorFileInfo(fileName, fileName);
        return mirrorFileInfo;
    }

    static class MirrorFileInfo {
        String fileName;
        String mirrorFileName;

        MirrorFileInfo(String fileName, String mirrorFileName) {
            this.fileName = fileName;
            this.mirrorFileName = mirrorFileName;
        }
    }
}

