/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.util;

import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.util.regex.Pattern;

public class RegexFilenameFilter
implements FilenameFilter,
FileFilter {
    Pattern _pattern;

    public RegexFilenameFilter(String regex) {
        this.setFilterExpression(regex);
    }

    public RegexFilenameFilter(String regex, int options) {
        this.setFilterExpression(regex, options);
    }

    public void setFilterExpression(String regex) {
        this._pattern = Pattern.compile(regex);
    }

    public void setFilterExpression(String regex, int options) {
        this._pattern = Pattern.compile(regex, options);
    }

    public boolean accept(File dir, String filename) {
        return this._pattern.matcher(filename).matches();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean accept(File pathname) {
        Pattern pattern = this._pattern;
        synchronized (pattern) {
            return this._pattern.matcher(pathname.getName()).matches();
        }
    }
}

