/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.util;

import com.tplus.transform.util.ISection;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;

public class SectionPrefImpl
implements ISection {
    private Preferences preferences;

    public SectionPrefImpl(Preferences preferences) {
        this.preferences = preferences;
    }

    public String getSectionName() {
        return this.preferences.name();
    }

    public String getKeyValue(String key, String defaultValue) {
        return this.preferences.get(key, defaultValue);
    }

    public int getKeyIntValue(String key, int defaultValue) {
        return this.preferences.getInt(key, defaultValue);
    }

    public long getKeyLongValue(String key, long defaultValue) {
        return this.preferences.getLong(key, defaultValue);
    }

    public boolean getKeyBoolValue(String key, boolean defaultValue) {
        return this.preferences.getBoolean(key, defaultValue);
    }

    public void addKeyValue(String key, String val) {
        this.preferences.put(key, val);
    }

    public void addKeyIntValue(String key, int value) {
        this.preferences.putInt(key, value);
    }

    public void addKeyBoolValue(String key, boolean val) {
        this.preferences.putBoolean(key, val);
    }

    public boolean removeKeyValue(String key) {
        this.preferences.remove(key);
        return true;
    }

    public void removeAllKeys() {
        String[] strings = this.getKeys();
        for (int i = 0; i < strings.length; ++i) {
            String string = strings[i];
            this.preferences.remove(string);
        }
    }

    public int getCount() {
        return this.getKeys().length;
    }

    public String[] getKeys() {
        try {
            return this.preferences.keys();
        }
        catch (BackingStoreException e) {
            e.printStackTrace();
            return new String[0];
        }
    }

    public String[] getValues() {
        String[] keys = this.getKeys();
        String[] values = new String[keys.length];
        for (int i = 0; i < keys.length; ++i) {
            String key = keys[i];
            values[i] = this.preferences.get(key, "");
        }
        return values;
    }
}

