/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.util;

import com.tplus.transform.util.SequencedHashMap;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;

public class SequencedHashSet
extends AbstractSet
implements Set,
Cloneable,
Serializable {
    static final long serialVersionUID = -5024744406713321676L;
    private transient SequencedHashMap map;
    private static final Object PRESENT = new Object();

    public SequencedHashSet() {
        this.map = new SequencedHashMap();
    }

    public SequencedHashSet(Collection c) {
        this.map = new SequencedHashMap(Math.max((int)((float)c.size() / 0.75f) + 1, 16));
        this.addAll(c);
    }

    public SequencedHashSet(int initialCapacity, float loadFactor) {
        this.map = new SequencedHashMap(initialCapacity, loadFactor);
    }

    public SequencedHashSet(int initialCapacity) {
        this.map = new SequencedHashMap(initialCapacity);
    }

    public Iterator iterator() {
        return this.map.keySet().iterator();
    }

    public int size() {
        return this.map.size();
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public boolean contains(Object o) {
        return this.map.containsKey(o);
    }

    public boolean add(Object o) {
        return this.map.put(o, PRESENT) == null;
    }

    public boolean remove(Object o) {
        return this.map.remove(o) == PRESENT;
    }

    public void clear() {
        this.map.clear();
    }

    public Object clone() {
        try {
            SequencedHashSet newSet = (SequencedHashSet)super.clone();
            newSet.map = (SequencedHashMap)this.map.clone();
            return newSet;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeInt(this.map.size() * 2);
        s.writeFloat(0.75f);
        s.writeInt(this.map.size());
        Iterator i = this.map.keySet().iterator();
        while (i.hasNext()) {
            s.writeObject(i.next());
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        int capacity = s.readInt();
        float loadFactor = s.readFloat();
        this.map = new SequencedHashMap(capacity, loadFactor);
        int size = s.readInt();
        for (int i = 0; i < size; ++i) {
            Object e = s.readObject();
            this.map.put(e, PRESENT);
        }
    }
}

