/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.util;

import com.tplus.transform.util.SequencedHashMap;
import com.tplus.transform.util.ServiceConfigurationError;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;

public final class ServiceLoader {
    private static final String PREFIX = "META-INF/services/";
    private Class service;
    private ClassLoader loader;
    private SequencedHashMap providers = new SequencedHashMap();
    private LazyIterator lookupIterator;

    public void reload() {
        this.providers.clear();
        this.lookupIterator = new LazyIterator(this.service, this.loader);
    }

    private ServiceLoader(Class svc, ClassLoader cl) {
        this.service = svc;
        this.loader = cl;
        this.reload();
    }

    private static void fail(Class service, String msg, Throwable cause) throws ServiceConfigurationError {
        throw new ServiceConfigurationError(service.getName() + ": " + msg, cause);
    }

    private static void fail(Class service, String msg) throws ServiceConfigurationError {
        throw new ServiceConfigurationError(service.getName() + ": " + msg);
    }

    private static void fail(Class service, URL u, int line, String msg) throws ServiceConfigurationError {
        ServiceLoader.fail(service, u + ":" + line + ": " + msg);
    }

    private int parseLine(Class service, URL u, BufferedReader r, int lc, List names) throws IOException, ServiceConfigurationError {
        int n;
        String ln = r.readLine();
        if (ln == null) {
            return -1;
        }
        int ci = ln.indexOf(35);
        if (ci >= 0) {
            ln = ln.substring(0, ci);
        }
        if ((n = (ln = ln.trim()).length()) != 0) {
            char cp;
            if (ln.indexOf(32) >= 0 || ln.indexOf(9) >= 0) {
                ServiceLoader.fail(service, u, lc, "Illegal configuration-file syntax");
            }
            if (!Character.isJavaIdentifierStart(cp = ln.charAt(0))) {
                ServiceLoader.fail(service, u, lc, "Illegal provider-class name: " + ln);
            }
            for (int i = 1; i < n; ++i) {
                cp = ln.charAt(i);
                if (Character.isJavaIdentifierPart(cp) || cp == '.') continue;
                ServiceLoader.fail(service, u, lc, "Illegal provider-class name: " + ln);
            }
            if (!this.providers.containsKey(ln) && !names.contains(ln)) {
                names.add(ln);
            }
        }
        return lc + 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Iterator parse(Class service, URL u) throws ServiceConfigurationError {
        InputStream in = null;
        BufferedReader r = null;
        ArrayList names = new ArrayList();
        try {
            in = u.openStream();
            r = new BufferedReader(new InputStreamReader(in, "utf-8"));
            int lc = 1;
            while ((lc = this.parseLine(service, u, r, lc, names)) >= 0) {
            }
        }
        catch (IOException x) {
            ServiceLoader.fail(service, "Error reading configuration file", x);
        }
        finally {
            try {
                if (r != null) {
                    r.close();
                }
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException y) {
                ServiceLoader.fail(service, "Error closing configuration file", y);
            }
        }
        return names.iterator();
    }

    public Iterator iterator() {
        return new Iterator(){
            Iterator knownProviders;
            {
                this.knownProviders = ServiceLoader.this.providers.entrySet().iterator();
            }

            public boolean hasNext() {
                if (this.knownProviders.hasNext()) {
                    return true;
                }
                return ServiceLoader.this.lookupIterator.hasNext();
            }

            public Object next() {
                if (this.knownProviders.hasNext()) {
                    return ((Map.Entry)this.knownProviders.next()).getValue();
                }
                return ServiceLoader.this.lookupIterator.next();
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static ServiceLoader load(Class service, ClassLoader loader) {
        return new ServiceLoader(service, loader);
    }

    public static ServiceLoader load(Class service) {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        return ServiceLoader.load(service, cl);
    }

    public static ServiceLoader loadInstalled(Class service) {
        ClassLoader prev = null;
        for (ClassLoader cl = ClassLoader.getSystemClassLoader(); cl != null; cl = cl.getParent()) {
            prev = cl;
        }
        return ServiceLoader.load(service, prev);
    }

    public String toString() {
        return "java.util.ServiceLoader[" + this.service.getName() + "]";
    }

    private class LazyIterator
    implements Iterator {
        Class service;
        ClassLoader loader;
        Enumeration configs = null;
        Iterator pending = null;
        String nextName = null;

        private LazyIterator(Class service, ClassLoader loader) {
            this.service = service;
            this.loader = loader;
        }

        public boolean hasNext() {
            if (this.nextName != null) {
                return true;
            }
            if (this.configs == null) {
                try {
                    String fullName = ServiceLoader.PREFIX + this.service.getName();
                    this.configs = this.loader == null ? ClassLoader.getSystemResources(fullName) : this.loader.getResources(fullName);
                }
                catch (IOException x) {
                    ServiceLoader.fail(this.service, "Error locating configuration files", x);
                }
            }
            while (this.pending == null || !this.pending.hasNext()) {
                if (!this.configs.hasMoreElements()) {
                    return false;
                }
                this.pending = ServiceLoader.this.parse(this.service, (URL)this.configs.nextElement());
            }
            this.nextName = (String)this.pending.next();
            return true;
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            String cn = this.nextName;
            this.nextName = null;
            try {
                Object o = Class.forName(cn, true, this.loader).newInstance();
                Object p = this.cast(o, this.service);
                ServiceLoader.this.providers.put(cn, p);
                return p;
            }
            catch (ClassNotFoundException x) {
                ServiceLoader.fail(this.service, "Provider " + cn + " not found");
            }
            catch (Throwable x) {
                ServiceLoader.fail(this.service, "Provider " + cn + " could not be instantiated: " + x, x);
            }
            throw new Error();
        }

        public Object cast(Object obj, Class cls) {
            if (obj != null && !cls.isInstance(obj)) {
                throw new ClassCastException();
            }
            return obj;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

