/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.util;

import com.tplus.transform.lang.FastStringBuffer;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public final class StringUtils {
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");
    public static final String EMPTY = "";
    public static final String[] EMPTY_ARRAY = new String[0];
    private static Set commonWords = new HashSet<String>(Arrays.asList("and", "in", "the", "of", "at", "for", "to"));

    public static String[] splitLines(String data) {
        ArrayList<String> lines = new ArrayList<String>();
        int lineStart = 0;
        for (int i = 0; i < data.length(); ++i) {
            char c = data.charAt(i);
            if (c != '\r' && c != '\n') continue;
            String line = data.substring(lineStart, i);
            lines.add(line);
            if (c == '\r' && i + 1 < data.length() && data.charAt(i + 1) == '\n') {
                ++i;
            }
            lineStart = i + 1;
        }
        if (data.length() - lineStart > 0) {
            String line = data.substring(lineStart, data.length());
            lines.add(line);
        }
        return lines.toArray(new String[lines.size()]);
    }

    public static String[] split(String data, int ch) {
        ArrayList<String> elems = new ArrayList<String>();
        int pos = -1;
        int i = 0;
        while ((pos = data.indexOf(ch, i)) != -1) {
            String elem = data.substring(i, pos);
            elems.add(elem);
            i = pos + 1;
        }
        elems.add(data.substring(i));
        return elems.toArray(new String[elems.size()]);
    }

    public static String[] split(String data, String ch) {
        ArrayList<String> elems = new ArrayList<String>();
        int pos = -1;
        int i = 0;
        while ((pos = data.indexOf(ch, i)) != -1) {
            String elem = data.substring(i, pos);
            elems.add(elem);
            i = pos + ch.length();
        }
        elems.add(data.substring(i));
        return elems.toArray(new String[elems.size()]);
    }

    public static String join(String separator, String[] strings) {
        int length = strings.length;
        if (length == 0) {
            return EMPTY;
        }
        StringBuffer buf = new StringBuffer(length * strings[0].length()).append(strings[0]);
        for (int i = 1; i < length; ++i) {
            buf.append(separator).append(strings[i]);
        }
        return buf.toString();
    }

    public static String replace(String str, String oldstr, String newstr) {
        if (str == null) {
            return null;
        }
        if (oldstr == null || oldstr.length() == 0 || newstr == null) {
            return str;
        }
        int lastMatchIndex = 0;
        int index = str.indexOf(oldstr);
        if (index != -1) {
            FastStringBuffer sb = new FastStringBuffer(str.length());
            while (index != -1) {
                sb.append(str, lastMatchIndex, index - lastMatchIndex);
                sb.append(newstr);
                lastMatchIndex = index + oldstr.length();
                index = str.indexOf(oldstr, lastMatchIndex);
            }
            sb.append(str, lastMatchIndex, str.length() - lastMatchIndex);
            return sb.toString();
        }
        return str;
    }

    public static String getStackTrace(Throwable t) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter((Writer)sw, true);
        t.printStackTrace(pw);
        pw.flush();
        pw.close();
        return sw.toString();
    }

    public static String replaceStringWithProperty(String str, Map props) {
        int i;
        LinkedHashMap arrangedMap = new LinkedHashMap();
        ArrayList list = new ArrayList(props.entrySet());
        Collections.sort(list, new Comparator(){

            public int compare(Object o1, Object o2) {
                Map.Entry entry1 = (Map.Entry)o1;
                Map.Entry entry2 = (Map.Entry)o2;
                return -(((String)entry1.getValue()).length() - ((String)entry2.getValue()).length());
            }
        });
        for (i = 0; i < list.size(); ++i) {
            Map.Entry entry = list.get(i);
            arrangedMap.put(entry.getKey(), entry.getValue());
        }
        if (str == null) {
            return null;
        }
        block1: for (i = 0; i < 100; ++i) {
            for (Map.Entry entry : arrangedMap.entrySet()) {
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                int match = str.indexOf(value);
                if (match == -1) continue;
                str = str.substring(0, match) + "${" + key + "}" + str.substring(match + value.length());
                continue block1;
            }
        }
        return str;
    }

    public static String replacePropertyInString(String str, Map props) {
        return StringUtils.replacePropertyInString(str, props, false);
    }

    public static String replacePropertyInString(String str, Map props, boolean strict) {
        int startIndex;
        if (str == null) {
            return null;
        }
        int start = 0;
        while ((startIndex = str.indexOf("${", start)) != -1) {
            start = startIndex + 2;
            int endIndex = str.indexOf(125, start);
            if (endIndex == -1) continue;
            String propName = str.substring(start, endIndex);
            String value = StringUtils.getProperty(props, propName);
            if (value != null) {
                String toRet = str.substring(0, startIndex);
                toRet = toRet + value;
                start = toRet.length();
                str = toRet = toRet + str.substring(endIndex + 1);
                continue;
            }
            if (!strict) continue;
            throw new IllegalArgumentException("Unrecognized property '" + propName + "' in " + str);
        }
        return str;
    }

    private static String getProperty(Map props, String propName) {
        String value;
        if (props instanceof Properties) {
            Properties properties = (Properties)props;
            value = properties.getProperty(propName);
        } else {
            value = (String)props.get(propName);
        }
        return value;
    }

    public static String replaceSystemPropertyInString(String str) {
        return StringUtils.replaceSystemPropertyInString(str, false);
    }

    public static String replaceSystemPropertyInString(String str, boolean strict) {
        Properties properties = System.getProperties();
        return StringUtils.replacePropertyInString(str, properties, strict);
    }

    public static String getString(char c, int count) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < count; ++i) {
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public static String midStr(String str, String startStr, String endStr) {
        str = StringUtils.rightStr(str, startStr);
        str = StringUtils.leftStr(str, endStr);
        return str;
    }

    public static String midStrExact(String str, String startStr, String endStr) {
        str = StringUtils.rightStrExact(str, startStr);
        str = StringUtils.leftStrExact(str, endStr);
        return str;
    }

    public static String leftStr(String str, String delimiterStr) {
        if (str == null) {
            return null;
        }
        if (delimiterStr == null) {
            return str;
        }
        int index = str.indexOf(delimiterStr);
        if (index != -1) {
            return str.substring(0, index);
        }
        return str;
    }

    public static String leftStrExact(String str, String delimiterStr) {
        if (str == null) {
            return null;
        }
        if (delimiterStr == null) {
            return str;
        }
        int index = str.indexOf(delimiterStr);
        if (index != -1) {
            return str.substring(0, index);
        }
        return EMPTY;
    }

    public static String lastLeftStr(String str, String delimiterStr) {
        if (str == null) {
            return null;
        }
        if (delimiterStr == null) {
            return str;
        }
        int index = str.lastIndexOf(delimiterStr);
        if (index != -1) {
            return str.substring(0, index);
        }
        return str;
    }

    public static String rightStr(String str, String delimiterStr) {
        if (str == null) {
            return null;
        }
        if (delimiterStr == null) {
            return str;
        }
        int index = str.indexOf(delimiterStr);
        if (index != -1) {
            return str.substring(index + delimiterStr.length());
        }
        return str;
    }

    public static String rightStrExact(String str, String delimiterStr) {
        if (str == null) {
            return null;
        }
        if (delimiterStr == null) {
            return str;
        }
        int index = str.indexOf(delimiterStr);
        if (index != -1) {
            return str.substring(index + delimiterStr.length());
        }
        return EMPTY;
    }

    public static String lastRightStr(String str, String delimiterStr) {
        if (str == null) {
            return null;
        }
        if (delimiterStr == null) {
            return str;
        }
        int index = str.lastIndexOf(delimiterStr);
        if (index != -1) {
            return str.substring(index + delimiterStr.length());
        }
        return str;
    }

    public static String capitalizeFirst(String str) {
        if (str.length() > 0) {
            StringBuffer upFldBuffer = new StringBuffer(str);
            upFldBuffer.setCharAt(0, Character.toUpperCase(str.charAt(0)));
            return upFldBuffer.toString();
        }
        return str;
    }

    public static String lowercaseFirst(String str) {
        if (str.length() > 0) {
            StringBuffer upFldBuffer = new StringBuffer(str);
            upFldBuffer.setCharAt(0, Character.toLowerCase(str.charAt(0)));
            return upFldBuffer.toString();
        }
        return str;
    }

    public static String fixNull(String str) {
        if (str == null) {
            return EMPTY;
        }
        return str;
    }

    public static String fixEmpty(String str) {
        if (EMPTY.equals(str)) {
            return null;
        }
        return str;
    }

    public static boolean valueEquals(String str1, String str2) {
        str1 = StringUtils.fixNull(str1);
        str2 = StringUtils.fixNull(str2);
        return str1.equals(str2);
    }

    public static String toIdentifier(String fldName) {
        return StringUtils.toIdentifier(fldName, false);
    }

    public static String toIdentifier(String fldName, boolean allowHypen) {
        StringBuffer out = new StringBuffer();
        if (fldName.length() > 0 && !StringUtils.isIdentifierStart(fldName.charAt(0))) {
            out.append("F");
        }
        for (int i = 0; i < fldName.length(); ++i) {
            int c = fldName.charAt(i);
            if (!(StringUtils.isIdentifierPart((char)c) || c == 45 && allowHypen)) {
                c = 95;
            }
            out.append((char)c);
        }
        return out.toString();
    }

    public static boolean isIdentifierStart(char ch) {
        return Character.isJavaIdentifierStart(ch) && ch != '$';
    }

    public static boolean isIdentifierPart(char ch) {
        return Character.isJavaIdentifierPart(ch) && ch != '$';
    }

    public static String toUpperCaseAt(String oldString, int index) throws NullPointerException, StringIndexOutOfBoundsException {
        int length = oldString.length();
        String newString = EMPTY;
        if (index >= length || index < 0) {
            throw new StringIndexOutOfBoundsException("Index " + index + " is out of bounds for string length " + length);
        }
        String upper = String.valueOf(oldString.charAt(index)).toUpperCase();
        String paddedString = oldString + " ";
        String beforeIndex = paddedString.substring(0, index);
        String afterIndex = paddedString.substring(index + 1);
        newString = (beforeIndex + upper + afterIndex).substring(0, length);
        return newString;
    }

    public static String intern(String str) {
        return str != null ? str.intern() : null;
    }

    public static boolean isEmpty(String str) {
        return str == null || StringUtils.isBlank(str);
    }

    static boolean isBlank(String str) {
        for (int i = 0; i < str.length(); ++i) {
            if (str.charAt(i) == ' ') continue;
            return false;
        }
        return true;
    }

    public static boolean isNotEmpty(String str) {
        return !StringUtils.isEmpty(str);
    }

    public static String toDisplayName(String varName) {
        List words = StringUtils.splitWords(varName);
        String toRet = EMPTY;
        for (int i = 0; i < words.size(); ++i) {
            String str;
            String word = (String)words.get(i);
            if (toRet.length() > 0) {
                toRet = toRet + " ";
            }
            toRet = StringUtils.isAllCaps(word) ? toRet + word : (StringUtils.isCommonWord(str = word.toLowerCase()) ? toRet + str : toRet + StringUtils.capitalizeFirst(str));
        }
        return toRet;
    }

    private static boolean isAllCaps(String str) {
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (!Character.isLetter(c) || Character.isUpperCase(c)) continue;
            return false;
        }
        return true;
    }

    private static boolean isCommonWord(String str) {
        return commonWords.contains(str);
    }

    public static List splitWords(String varName) {
        ArrayList<String> words = new ArrayList<String>();
        boolean currentSmallCase = false;
        int wordStart = 0;
        for (int i = 0; i < varName.length(); ++i) {
            char c = varName.charAt(i);
            if (c == '_' || c == '-' || c == ' ') {
                String word = varName.substring(wordStart, i);
                if (word.length() > 0) {
                    words.add(word);
                }
                currentSmallCase = false;
                wordStart = i + 1;
            }
            if (i <= wordStart || !Character.isLetter(c)) continue;
            boolean upper = Character.isUpperCase(c);
            if (upper) {
                if (currentSmallCase) {
                    String word = varName.substring(wordStart, i);
                    if (word.length() > 0) {
                        words.add(word);
                    }
                    wordStart = i;
                }
                currentSmallCase = false;
                continue;
            }
            currentSmallCase = true;
        }
        String word = varName.substring(wordStart, varName.length());
        if (word.length() > 0) {
            words.add(word);
        }
        return words;
    }

    public static boolean isIdentifier(String name) {
        if (name.length() == 0) {
            return false;
        }
        if (!StringUtils.isIdentifierStart(name.charAt(0))) {
            return false;
        }
        for (int i = 1; i < name.length(); ++i) {
            if (StringUtils.isIdentifierPart(name.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static int indexOneOf(String findIn, String chars) {
        return StringUtils.indexOneOf(findIn, chars, 0);
    }

    public static int indexOneOf(String findIn, String chars, int fromIndex) {
        return StringUtils.indexOneOf(findIn, chars.toCharArray(), fromIndex);
    }

    public static int indexOneOf(String findIn, char[] chars, int fromIndex) {
        int max = findIn.length();
        if (fromIndex < 0) {
            fromIndex = 0;
        } else if (fromIndex >= findIn.length()) {
            return -1;
        }
        for (int i = fromIndex; i < max; ++i) {
            for (int j = 0; j < chars.length; ++j) {
                char aChar = chars[j];
                if (findIn.charAt(i) != aChar) continue;
                return i;
            }
        }
        return -1;
    }

    public static boolean wildcardMatch(String name, String wildcard) {
        return StringUtils.wildcardMatch(name, wildcard, '\u0000');
    }

    public static boolean wildcardMatch(String name, String wildcard, char sentinel) {
        if (name == null && wildcard == null) {
            return true;
        }
        if (name == null || wildcard == null) {
            return false;
        }
        if (wildcard.length() > 0 && name.length() > 0) {
            char nameChar = name.charAt(name.length() - 1);
            char wildChar = wildcard.charAt(wildcard.length() - 1);
            if (Character.isJavaIdentifierPart(wildChar) && wildChar != '_' && wildChar != nameChar) {
                return false;
            }
        }
        return StringUtils.match(name, 0, wildcard, 0, sentinel);
    }

    static boolean match(String name, int nameStart, String wildcard, int wildcardStart, char sentinel) {
        int nameIndex = nameStart;
        int nameLength = name.length();
        for (int wildcardIndex = wildcardStart; wildcardIndex < wildcard.length(); ++wildcardIndex) {
            char w = wildcard.charAt(wildcardIndex);
            if (w == '?') {
                if (nameLength <= nameIndex || name.charAt(nameIndex) == sentinel) continue;
                ++nameIndex;
                continue;
            }
            if (w == '*') {
                char sentinelChar = sentinel;
                if (wildcardIndex + 1 < wildcard.length() && wildcard.charAt(wildcardIndex + 1) == '*') {
                    sentinelChar = '\u0000';
                }
                for (int i = nameIndex; i <= nameLength; ++i) {
                    boolean match = StringUtils.match(name, i, wildcard, wildcardIndex + 1, sentinel);
                    if (i != nameLength && name.charAt(i) == sentinelChar) {
                        return match;
                    }
                    if (!match) continue;
                    return match;
                }
                return false;
            }
            if (nameLength > nameIndex) {
                char nameChar = name.charAt(nameIndex);
                if (nameChar == w) {
                    ++nameIndex;
                    continue;
                }
                if (w == '_' && !Character.isJavaIdentifierPart(nameChar)) {
                    ++nameIndex;
                    continue;
                }
            }
            return false;
        }
        return nameIndex == nameLength;
    }

    public static boolean isPartOfWord(char c) {
        return Character.isJavaIdentifierPart(c) || c == '-';
    }

    public static String lpad(String str, char pad_char, int max_chars) {
        String string = str = str == null ? EMPTY : str;
        if (max_chars < 0) {
            return str;
        }
        if (max_chars < str.length()) {
            return str.substring(0, max_chars);
        }
        if (max_chars == str.length()) {
            return str;
        }
        char[] chars = new char[max_chars - str.length()];
        Arrays.fill(chars, pad_char);
        return new String(chars) + str;
    }

    public static void pad(StringBuilder str, CharSequence actualStr, char pad_char, boolean isLeftPad, int max_chars) {
        if (str == null || max_chars < 0) {
            return;
        }
        int length = actualStr.length();
        if (max_chars < length) {
            str.append(actualStr.subSequence(0, max_chars));
        } else if (max_chars == length) {
            str.append(actualStr);
        } else {
            char[] chars = new char[max_chars - length];
            Arrays.fill(chars, pad_char);
            if (isLeftPad) {
                str.append(chars).append(actualStr);
            } else {
                str.append(actualStr).append(chars);
            }
        }
    }

    public static void pad(StringBuilder str, String actualStr, char[] pad_char, boolean isLeftPad, int max_chars) {
        if (str == null || max_chars < 0) {
            return;
        }
        int length = actualStr.length();
        if (max_chars < length) {
            str.append(actualStr.substring(0, max_chars));
        } else if (max_chars == length) {
            str.append(actualStr);
        } else if (pad_char.length == max_chars) {
            int maxCharLength = max_chars - length;
            if (isLeftPad) {
                str.append(pad_char, 0, maxCharLength).append(actualStr);
            } else {
                str.append(actualStr).append(pad_char, 0, maxCharLength);
            }
        }
    }

    public static String trim(String name) {
        if (name != null) {
            name = name.trim();
        }
        return name;
    }

    public static void testWild(String[] args) {
        System.out.println(StringUtils.wildcardMatch("Hello.world", "Hello.world*", '.'));
        System.out.println(StringUtils.wildcardMatch("Hello.world", "H*o.*", '.'));
        System.out.println(StringUtils.wildcardMatch("Hello.world", "Hel*o.*d", '.'));
        System.out.println(StringUtils.wildcardMatch("Hello.world", "Hel*o.*d*", '.'));
        System.out.println(StringUtils.wildcardMatch("Hello.world", "*.*", '.'));
        System.out.println(StringUtils.wildcardMatch("Hello.world", "*o.*", '.'));
        System.out.println(StringUtils.wildcardMatch("Hello.world", "H*", '.'));
        System.out.println(StringUtils.wildcardMatch("Hello.world", "*.*.*", '.'));
        System.out.println(StringUtils.wildcardMatch("M:\\transform\\GeneralSpecs\\Swift\\SWIFMX-SRG2007\\Samples\\Sample9\\setr.057.001.01.xi", "*setr.057.001.01*"));
    }

    public static void cmtmain(String[] args) {
        StringUtils.testWild(args);
    }

    public static void main2(String[] args) {
    }

    public static boolean equals(String str1, String str2) {
        if (str1 == str2) {
            return true;
        }
        if (str1 == null || str2 == null) {
            return false;
        }
        return str1.equals(str2);
    }

    public static boolean isInt(String value) {
        try {
            Integer.parseInt(value);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static char[] union(char[] c1, char[] c2) {
        int i;
        StringBuffer sb = new StringBuffer();
        for (i = 0; i < c1.length; ++i) {
            if (StringUtils.contains(sb, c1[i])) continue;
            sb.append(c1[i]);
        }
        for (i = 0; i < c2.length; ++i) {
            if (StringUtils.contains(sb, c2[i])) continue;
            sb.append(c2[i]);
        }
        char[] c3 = new char[sb.length()];
        sb.getChars(0, sb.length(), c3, 0);
        Arrays.sort(c3);
        return c3;
    }

    public static boolean contains(StringBuffer haystack, char c) {
        for (int i = 0; i < haystack.length(); ++i) {
            if (haystack.charAt(i) != c) continue;
            return true;
        }
        return false;
    }

    public static void append(StringBuilder stringBuilder, String fixed, String toWrite, boolean positon, boolean autoLineFeed) {
        if (StringUtils.isNotEmpty(toWrite)) {
            if (positon) {
                if (autoLineFeed) {
                    stringBuilder.append(stringBuilder.toString().length() > 0 ? "\n" : EMPTY);
                }
                stringBuilder.append(fixed);
                stringBuilder.append(toWrite);
            } else {
                stringBuilder.append(toWrite);
                stringBuilder.append(fixed);
            }
        }
    }

    public static void append(StringBuilder stringBuilder, String str) {
        if (StringUtils.isNotEmpty(str)) {
            stringBuilder.append(str);
        }
    }

    public static void main(String[] args) {
        String str = "ftp://downloads.volantetech.com/Releases/R400B1100\\Bloomberg\\Bloomberg-20130408.jaz";
        System.out.println(str.replace("\\", "/"));
    }
}

