/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.util;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

public class TimeSpanUtil {
    static final long ONE_SECOND = 1000L;
    static final long ONE_MINUTE = 60000L;
    static final long ONE_HOUR = 3600000L;
    static final long ONE_DAY = 86400000L;
    static final long ONE_MONTH = 2592000000L;
    static final long ONE_YEAR = 31104000000L;

    public static String getRelativeDateString(Date date, String pattern) {
        Date now = new Date();
        if (now.after(date)) {
            long millis = now.getTime() - date.getTime();
            if (millis < 60000L) {
                long val = millis / 1000L;
                return val + "  " + TimeSpanUtil.plural("second", val) + " back";
            }
            if (millis < 3600000L) {
                long val = millis / 60000L;
                return val + "  " + TimeSpanUtil.plural("minute", val) + " back";
            }
            if (millis < 86400000L) {
                long val = millis / 3600000L;
                return val + "  " + TimeSpanUtil.plural("hour", val) + " back";
            }
            if (millis < 2592000000L) {
                long val = now.getTime() / 86400000L - date.getTime() / 86400000L;
                if (val == 1L) {
                    return "Yesterday";
                }
                return val + "  " + TimeSpanUtil.plural("day", val) + " back";
            }
            if (millis < 31104000000L) {
                long val = millis / 2592000000L;
                long days = millis % 2592000000L / 86400000L;
                return val + "  " + TimeSpanUtil.plural("month", val) + " " + (days > 0L ? "and " + days + " " + TimeSpanUtil.plural("day", days) + " " : "") + "back";
            }
            long val = millis / 31104000000L;
            long months = millis % 31104000000L / 2592000000L;
            return val + "  " + TimeSpanUtil.plural("year", val) + " " + (months > 0L ? "and " + months + " " + TimeSpanUtil.plural("month", months) + " " : "") + "back";
        }
        if (pattern != null) {
            SimpleDateFormat sdf = new SimpleDateFormat(pattern);
            return sdf.format(date);
        }
        return DateFormat.getInstance().format(date);
    }

    static String plural(String name, long count) {
        if (count > 1L) {
            return name + "s";
        }
        return name;
    }
}

