/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.util.bean.converters;

import com.tplus.transform.util.bean.converters.AbstractConverter;

public final class BooleanConverter
extends AbstractConverter {
    public static final Object NO_DEFAULT = new Object();
    private String[] trueStrings = new String[]{"true", "yes", "y", "on", "1"};
    private String[] falseStrings = new String[]{"false", "no", "n", "off", "0"};

    public BooleanConverter() {
    }

    public BooleanConverter(Object defaultValue) {
        if (defaultValue != NO_DEFAULT) {
            this.setDefaultValue(defaultValue);
        }
    }

    public BooleanConverter(String[] trueStrings, String[] falseStrings) {
        this.trueStrings = BooleanConverter.copyStrings(trueStrings);
        this.falseStrings = BooleanConverter.copyStrings(falseStrings);
    }

    public BooleanConverter(String[] trueStrings, String[] falseStrings, Object defaultValue) {
        this.trueStrings = BooleanConverter.copyStrings(trueStrings);
        this.falseStrings = BooleanConverter.copyStrings(falseStrings);
        if (defaultValue != NO_DEFAULT) {
            this.setDefaultValue(defaultValue);
        }
    }

    protected Class getDefaultType() {
        return Boolean.class;
    }

    protected Object convertToType(Class type, Object value) throws Throwable {
        if (Boolean.class.equals((Object)type) || Boolean.TYPE.equals(type)) {
            int i;
            String stringValue = value.toString().toLowerCase();
            for (i = 0; i < this.trueStrings.length; ++i) {
                if (!this.trueStrings[i].equals(stringValue)) continue;
                return type.cast(Boolean.TRUE);
            }
            for (i = 0; i < this.falseStrings.length; ++i) {
                if (!this.falseStrings[i].equals(stringValue)) continue;
                return type.cast(Boolean.FALSE);
            }
        }
        throw this.conversionException(type, value);
    }

    private static String[] copyStrings(String[] src) {
        String[] dst = new String[src.length];
        for (int i = 0; i < src.length; ++i) {
            dst[i] = src[i].toLowerCase();
        }
        return dst;
    }
}

