/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.util.diff;

import com.tplus.transform.util.diff.DiffResultSpan;
import com.tplus.transform.util.diff.DiffState;
import com.tplus.transform.util.diff.DiffStateList;
import com.tplus.transform.util.diff.ElementComparator;
import com.tplus.transform.util.diff.IDiffList;
import com.tplus.transform.util.diff.LineReport;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class DiffEngine {
    public static final int FastImperfect = 0;
    public static final int Medium = 1;
    public static final int SlowPerfect = 2;
    private IDiffList source = null;
    private IDiffList dest = null;
    private List matchList = null;
    private int level = 2;
    private DiffStateList stateList = null;
    private ElementComparator comparator;

    private int getSourceMatchLength(int destIndex, int sourceIndex, int maxLength) {
        int matchCount;
        for (matchCount = 0; matchCount < maxLength && this.comparator.getSimilarityIndex(this.dest.get(destIndex + matchCount), this.source.get(sourceIndex + matchCount)) == 0; ++matchCount) {
        }
        return matchCount;
    }

    public void processDiff(IDiffList source, IDiffList destination, int level, ElementComparator comparator) {
        this.level = level;
        this.processDiff(source, destination, comparator);
    }

    public void processDiff(IDiffList source, IDiffList destination, ElementComparator comparator) {
        this.source = source;
        this.dest = destination;
        this.comparator = comparator;
        this.matchList = new ArrayList();
        int dcount = this.dest.size();
        int scount = this.source.size();
        if (dcount > 0 && scount > 0) {
            this.stateList = new DiffStateList(dcount);
            this.processRange(0, dcount - 1, 0, scount - 1);
        }
    }

    public LineReport getLineReport() {
        return new LineReport(this.DiffReport());
    }

    public List DiffReport() {
        ArrayList<DiffResultSpan> retval = new ArrayList<DiffResultSpan>();
        int dcount = this.dest.size();
        int scount = this.source.size();
        if (dcount == 0) {
            if (scount > 0) {
                retval.add(DiffResultSpan.createDeleteSource(0, scount));
            }
            return retval;
        }
        if (scount == 0) {
            retval.add(DiffResultSpan.createAddDestination(0, dcount));
            return retval;
        }
        Collections.sort(this.matchList);
        int curDest = 0;
        int curSource = 0;
        DiffResultSpan last = null;
        for (int i = 0; i < this.matchList.size(); ++i) {
            DiffResultSpan drs = (DiffResultSpan)this.matchList.get(i);
            if (!this.addChanges(retval, curDest, drs.getDestIndex(), curSource, drs.getSourceIndex()) && last != null) {
                last.addLength(drs.getLength());
            } else {
                retval.add(drs);
            }
            curDest = drs.getDestIndex() + drs.getLength();
            curSource = drs.getSourceIndex() + drs.getLength();
            last = drs;
        }
        this.addChanges(retval, curDest, dcount, curSource, scount);
        return retval;
    }

    private void getLongestSourceMatch(DiffState curItem, int destIndex, int destEnd, int sourceStart, int sourceEnd) {
        int maxDestLength = destEnd - destIndex + 1;
        int curLength = 0;
        int curBestLength = 0;
        int curBestIndex = -1;
        int maxLength = 0;
        for (int sourceIndex = sourceStart; sourceIndex <= sourceEnd && (maxLength = Math.min(maxDestLength, sourceEnd - sourceIndex + 1)) > curBestLength; ++sourceIndex) {
            curLength = this.getSourceMatchLength(destIndex, sourceIndex, maxLength);
            if (curLength > curBestLength) {
                curBestIndex = sourceIndex;
                curBestLength = curLength;
            }
            sourceIndex += curBestLength;
        }
        if (curBestIndex == -1) {
            curItem.setNoMatch();
        } else {
            curItem.setMatch(curBestIndex, curBestLength);
        }
    }

    private void processRange(int destStart, int destEnd, int sourceStart, int sourceEnd) {
        int curBestIndex = -1;
        int curBestLength = -1;
        int maxPossibleDestLength = 0;
        DiffState curItem = null;
        DiffState bestItem = null;
        block4: for (int destIndex = destStart; destIndex <= destEnd && (maxPossibleDestLength = destEnd - destIndex + 1) > curBestLength; ++destIndex) {
            curItem = this.stateList.get(destIndex);
            if (!curItem.hasValidLength(sourceStart, sourceEnd, maxPossibleDestLength)) {
                this.getLongestSourceMatch(curItem, destIndex, destEnd, sourceStart, sourceEnd);
            }
            if (curItem.getStatus() != 1) continue;
            switch (this.level) {
                case 0: {
                    if (curItem.getLength() > curBestLength) {
                        curBestIndex = destIndex;
                        curBestLength = curItem.getLength();
                        bestItem = curItem;
                    }
                    destIndex += curItem.getLength() - 1;
                    continue block4;
                }
                case 1: {
                    if (curItem.getLength() <= curBestLength) continue block4;
                    curBestIndex = destIndex;
                    curBestLength = curItem.getLength();
                    bestItem = curItem;
                    destIndex += curItem.getLength() - 1;
                    continue block4;
                }
                default: {
                    if (curItem.getLength() <= curBestLength) continue block4;
                    curBestIndex = destIndex;
                    curBestLength = curItem.getLength();
                    bestItem = curItem;
                }
            }
        }
        if (curBestIndex >= 0) {
            int sourceIndex = bestItem.getStartIndex();
            this.matchList.add(DiffResultSpan.createNoChange(curBestIndex, sourceIndex, curBestLength));
            if (destStart < curBestIndex && sourceStart < sourceIndex) {
                this.processRange(destStart, curBestIndex - 1, sourceStart, sourceIndex - 1);
            }
            int upperDestStart = curBestIndex + curBestLength;
            int upperSourceStart = sourceIndex + curBestLength;
            if (destEnd > upperDestStart && sourceEnd > upperSourceStart) {
                this.processRange(upperDestStart, destEnd, upperSourceStart, sourceEnd);
            }
        }
    }

    private boolean addChanges(List report, int curDest, int nextDest, int curSource, int nextSource) {
        boolean retval = false;
        int diffDest = nextDest - curDest;
        int diffSource = nextSource - curSource;
        int minDiff = 0;
        if (diffDest > 0) {
            if (diffSource > 0) {
                minDiff = Math.min(diffDest, diffSource);
                report.add(DiffResultSpan.createReplace(curDest, curSource, minDiff));
                if (diffDest > diffSource) {
                    report.add(DiffResultSpan.createAddDestination(curDest += minDiff, diffDest - diffSource));
                } else if (diffSource > diffDest) {
                    report.add(DiffResultSpan.createDeleteSource(curSource += minDiff, diffSource - diffDest));
                }
            } else {
                report.add(DiffResultSpan.createAddDestination(curDest, diffDest));
            }
            retval = true;
        } else if (diffSource > 0) {
            report.add(DiffResultSpan.createDeleteSource(curSource, diffSource));
            retval = true;
        }
        return retval;
    }

    public boolean hasDiffs() {
        List list = this.DiffReport();
        for (int i = 0; i < list.size(); ++i) {
            DiffResultSpan diffResultSpan = (DiffResultSpan)list.get(i);
            if (diffResultSpan.getStatus() == 0) continue;
            return true;
        }
        return false;
    }
}

