/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.util.diff;

import com.tplus.transform.util.diff.MaskExpression;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class DiffOptions
implements Cloneable,
Serializable {
    public static final String IGNORE_WHITE_SPACE_START_LINE = "Ignore at start of lines";
    public static final String IGNORE_WHITE_SPACE_END_LINE = "Ignore at end of lines";
    public static final String IGNORE_WHITE_SPACE_START_END_LINE = "Ignore at stand and end of lines";
    public static final String IGNORE_WHITE_SPACE = "Ignore all";
    public static final String IGNORE_WHITE_SPACE_NOT = "Do not Ignore";
    String ignoreWhiteSpace;
    Boolean ignoreCharacterCase;
    Boolean ignoreLineEnding;
    List maskExpressionList = new ArrayList();
    boolean binary;
    String defaultEncoding;
    Boolean autoDetectEncoding;

    public static boolean hasSetting(DiffOptions diffOptions) {
        return diffOptions != null && diffOptions.hasSetting();
    }

    public boolean hasSetting() {
        return this.ignoreWhiteSpace != null || this.ignoreCharacterCase != null || this.ignoreLineEnding != null || this.maskExpressionList.size() > 0;
    }

    public void setIgnoreWhiteSpace(String ignoreWhiteSpace) {
        this.ignoreWhiteSpace = ignoreWhiteSpace;
    }

    public boolean isIgnoreCharacterCase() {
        return DiffOptions.toBoolean(this.ignoreCharacterCase);
    }

    private static boolean toBoolean(Boolean ignoreCharacterCase) {
        return ignoreCharacterCase == null ? false : ignoreCharacterCase;
    }

    public void setIgnoreCharacterCase(Boolean ignoreCharacterCase) {
        this.ignoreCharacterCase = ignoreCharacterCase;
    }

    public void setIgnoreCharacterCase(boolean ignoreCharacterCase) {
        this.ignoreCharacterCase = ignoreCharacterCase;
    }

    public String getIgnoreWhiteSpace() {
        return this.ignoreWhiteSpace;
    }

    public Boolean getIgnoreCharacterCase() {
        return this.ignoreCharacterCase;
    }

    public Boolean getIgnoreLineEnding() {
        return this.ignoreLineEnding;
    }

    public boolean isIgnoreLineEnding() {
        return DiffOptions.toBoolean(this.ignoreLineEnding);
    }

    public void setIgnoreLineEnding(Boolean ignoreLineEnding) {
        this.ignoreLineEnding = ignoreLineEnding;
    }

    public String getDefaultEncoding() {
        return this.defaultEncoding;
    }

    public void setDefaultEncoding(String defaultEncoding) {
        this.defaultEncoding = defaultEncoding;
    }

    public Boolean getAutoDetectEncoding() {
        return this.autoDetectEncoding;
    }

    public void setAutoDetectEncoding(Boolean autoDetectEncoding) {
        this.autoDetectEncoding = autoDetectEncoding;
    }

    public List getMaskExpressionList() {
        return this.maskExpressionList;
    }

    public void setMaskExpressionList(List maskExpressionList) {
        this.maskExpressionList = maskExpressionList;
    }

    public void addMaskExpression(String regex, boolean ignoreLine) {
        this.maskExpressionList.add(new MaskExpression(regex, ignoreLine));
    }

    public void addMaskExpression(MaskExpression maskExpression) {
        this.maskExpressionList.add(maskExpression);
    }

    public DiffOptions merge(DiffOptions parentOptions) {
        if (!DiffOptions.hasSetting(parentOptions)) {
            return this;
        }
        DiffOptions diffOptions = new DiffOptions();
        diffOptions.ignoreWhiteSpace = this.merge(this.ignoreWhiteSpace, parentOptions.ignoreWhiteSpace);
        diffOptions.ignoreCharacterCase = this.merge(this.ignoreCharacterCase, parentOptions.ignoreCharacterCase);
        diffOptions.ignoreLineEnding = this.merge(this.ignoreLineEnding, parentOptions.ignoreLineEnding);
        diffOptions.defaultEncoding = this.merge(this.defaultEncoding, parentOptions.defaultEncoding);
        diffOptions.autoDetectEncoding = this.merge(this.autoDetectEncoding, parentOptions.autoDetectEncoding);
        if (this.maskExpressionList.size() > 0) {
            diffOptions.maskExpressionList.addAll(this.maskExpressionList);
        } else {
            diffOptions.maskExpressionList.addAll(parentOptions.maskExpressionList);
        }
        return diffOptions;
    }

    private Boolean merge(Boolean ignoreWhiteSpace1, Boolean ignoreWhiteSpace2) {
        return ignoreWhiteSpace1 != null ? ignoreWhiteSpace1 : ignoreWhiteSpace2;
    }

    private String merge(String ignoreWhiteSpace1, String ignoreWhiteSpace2) {
        return ignoreWhiteSpace1 != null ? ignoreWhiteSpace1 : ignoreWhiteSpace2;
    }

    public boolean isBinary() {
        return this.binary;
    }

    public void setBinary(boolean binary) {
        this.binary = binary;
    }

    public boolean isIgnoreWhiteSpace() {
        return IGNORE_WHITE_SPACE.equals(this.ignoreWhiteSpace);
    }

    public boolean isIgnoreWhiteSpaceAtStart() {
        return IGNORE_WHITE_SPACE_START_LINE.equals(this.ignoreWhiteSpace);
    }

    public boolean isIgnoreWhiteSpaceAtEnd() {
        return IGNORE_WHITE_SPACE_END_LINE.equals(this.ignoreWhiteSpace);
    }

    public boolean isIgnoreWhiteSpaceAtStartEnd() {
        return IGNORE_WHITE_SPACE_START_END_LINE.equals(this.ignoreWhiteSpace);
    }

    public String toString() {
        return "DiffOptions{ignoreWhiteSpace=" + this.ignoreWhiteSpace + ", ignoreCharacterCase=" + this.ignoreCharacterCase + ", ignoreLineEnding=" + this.ignoreLineEnding + ", maskExpressionList=" + this.maskExpressionList + ", binary=" + this.binary + '}';
    }

    public Object clone() {
        try {
            DiffOptions cloned = (DiffOptions)super.clone();
            return cloned;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }
}

