/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.util.diff;

import com.tplus.transform.util.diff.ElementComparator;
import com.tplus.transform.util.diff.MatchProcessor;
import com.tplus.transform.util.diff.ObjectMatch;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class MapMatcher {
    ElementComparator comparator;
    MatchProcessor matchProcessor;

    public MapMatcher(ElementComparator comparator) {
        this.comparator = comparator;
        this.matchProcessor = (MatchProcessor)((Object)comparator);
    }

    public void match(Map children1, Map children2) {
        int i;
        ArrayList children1List = new ArrayList(children1.keySet());
        ArrayList children2List = new ArrayList(children2.keySet());
        this.match(children1List, children2List, 0);
        if (children1List.size() > 0 && children2List.size() > 0) {
            this.match(children1List, children2List, 2);
        }
        for (i = 0; i < children1List.size(); ++i) {
            this.applyMatch(new ObjectMatch(children1List.get(i), null));
        }
        for (i = 0; i < children2List.size(); ++i) {
            this.applyMatch(new ObjectMatch(null, children2List.get(i)));
        }
    }

    private void match(List children1, List children2, int similarityLimit) {
        for (int i = 0; i < children1.size(); ++i) {
            Object elm1 = children1.get(i);
            ObjectMatch match = this.matchNext(elm1, children2, similarityLimit);
            if (match == null) continue;
            this.applyMatch(match);
            children1.remove(match.getElement1());
            children2.remove(match.getElement2());
            --i;
        }
    }

    ObjectMatch matchNext(Object elm1, List children2, int similarityLimit) {
        int bestIndex = Integer.MAX_VALUE;
        Object bestMatch = null;
        for (int i = 0; i < children2.size(); ++i) {
            Object elm2 = children2.get(i);
            if (elm1.getClass() != elm2.getClass()) continue;
            int similarityIndex = this.getSimilarityIndex(elm1, elm2);
            if (similarityIndex == 0) {
                return new ObjectMatch(elm1, elm2);
            }
            if (similarityIndex <= 0 || similarityIndex >= similarityLimit) continue;
            bestMatch = elm2;
            bestIndex = similarityIndex;
        }
        if (bestIndex < similarityLimit) {
            return new ObjectMatch(elm1, bestMatch);
        }
        return null;
    }

    int getSimilarityIndex(Object elm1, Object elm2) {
        return this.comparator.getSimilarityIndex(elm1, elm2);
    }

    void applyMatch(ObjectMatch match) {
        this.matchProcessor.applyMatch(match);
    }
}

