/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.util.diff;

public class Mask
implements Comparable {
    int start;
    int end;
    String text;

    Mask(int start, int end) {
        this.start = start;
        this.end = end;
    }

    public int getStart() {
        return this.start;
    }

    public int getEnd() {
        return this.end;
    }

    public int getLength() {
        return this.end - this.start;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Mask) {
            Mask other = (Mask)obj;
            return this.start == other.start && this.end == other.end;
        }
        return false;
    }

    public boolean subsumes(Mask other) {
        return this.start <= other.start && this.end >= other.end;
    }

    public int compareTo(Object o) {
        Mask other = (Mask)o;
        int i = this.start - other.start;
        if (i == 0) {
            i = this.end - other.end;
        }
        return i;
    }

    public Mask merge(Mask other) {
        return new Mask(Math.min(this.start, other.start), Math.max(this.end, other.end));
    }

    boolean intersects(Mask other) {
        if (this.start <= other.start && other.start < this.end) {
            return true;
        }
        return other.start <= this.start && this.start < other.end;
    }
}

