/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.util.diff;

import com.tplus.transform.util.diff.DiffOptions;
import com.tplus.transform.util.diff.Mask;
import com.tplus.transform.util.diff.MaskExpression;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MaskedText {
    String originalText;
    String maskedText;
    List masks;
    LineManager oldLineManager = new LineManager();
    LineManager newLineManager = new LineManager();
    int[] oldVsNewLineMap;

    public MaskedText(String originalText) {
        this.originalText = originalText;
        this.maskedText = originalText;
        this.masks = new ArrayList();
    }

    public String getOriginalText() {
        return this.originalText;
    }

    public String getMaskedText() {
        return this.maskedText;
    }

    public void mask(DiffOptions diffOptions) {
        ArrayList maskExpressions = new ArrayList(diffOptions.getMaskExpressionList());
        ArrayList<Mask> masks = new ArrayList<Mask>();
        int options = diffOptions.isIgnoreCharacterCase() ? 2 : 0;
        options |= 8;
        this.setupWhitespaceExpressions(diffOptions, maskExpressions);
        this.oldLineManager.compute(this.originalText);
        for (int i = 0; i < maskExpressions.size(); ++i) {
            MaskExpression maskExpression = (MaskExpression)maskExpressions.get(i);
            if (!maskExpression.isEnabled()) continue;
            boolean forceLineUnChanged = maskExpression.isForceLineUnChanged();
            String regex = maskExpression.getRegex();
            Pattern pattern = Pattern.compile(regex, options);
            Matcher matcher = pattern.matcher(this.originalText);
            while (matcher.find()) {
                Mask mask;
                int start = matcher.start();
                int end = matcher.end();
                if (forceLineUnChanged) {
                    int newStart = this.oldLineManager.getLineStart(this.oldLineManager.getLineAt(start));
                    int newEnd = this.oldLineManager.getLineEnd(this.oldLineManager.getLineAt(end));
                    mask = new Mask(newStart, newEnd);
                } else {
                    mask = new Mask(start, end);
                }
                masks.add(mask);
            }
        }
        List mergedMasks = MaskedText.merge(masks);
        String maskedText = this.originalText;
        if (diffOptions.isIgnoreCharacterCase()) {
            maskedText = maskedText.toLowerCase();
        }
        if (mergedMasks.size() > 0) {
            StringBuffer toRet = new StringBuffer(maskedText);
            for (int i = mergedMasks.size() - 1; i >= 0; --i) {
                Mask mask = (Mask)mergedMasks.get(i);
                toRet.replace(mask.start, mask.end, "");
            }
            maskedText = toRet.toString();
        }
        this.maskedText = maskedText;
        this.newLineManager.compute(maskedText);
        this.masks = mergedMasks;
    }

    private void setupWhitespaceExpressions(DiffOptions diffOptions, List maskExpressions) {
        if (diffOptions.isIgnoreWhiteSpace()) {
            maskExpressions.add(0, new MaskExpression("[ \\t]*", false));
        } else if (diffOptions.isIgnoreWhiteSpaceAtStart()) {
            maskExpressions.add(0, new MaskExpression("^[ \\t]*", false));
        } else if (diffOptions.isIgnoreWhiteSpaceAtEnd()) {
            maskExpressions.add(0, new MaskExpression("[ \\t]*$", false));
        } else if (diffOptions.isIgnoreWhiteSpaceAtStartEnd()) {
            maskExpressions.add(0, new MaskExpression("^[ \\t]*", false));
            maskExpressions.add(0, new MaskExpression("[ \\t]*$", false));
        }
    }

    private static List merge(List masks) {
        Collections.sort(masks);
        ArrayList<Mask> mergedMasks = new ArrayList<Mask>();
        Mask current = null;
        for (int i = 0; i < masks.size(); ++i) {
            Mask mask = (Mask)masks.get(i);
            if (current == null) {
                current = mask;
                continue;
            }
            if (current.intersects(mask)) {
                current = current.merge(mask);
                continue;
            }
            mergedMasks.add(current);
            current = mask;
        }
        if (current != null) {
            mergedMasks.add(current);
        }
        return mergedMasks;
    }

    public int mapNewLineToOld(int newLine) {
        int newLineStart = this.newLineManager.getLineStart(newLine);
        int oldOffset = this.mapNewOffsetToOld(newLineStart);
        return this.oldLineManager.getLineAt(oldOffset);
    }

    public int mapNewColumnToOld(int newLine, int newColumn) {
        int newOffset = this.newLineManager.getOffset(newLine, newColumn);
        int oldOffset = this.mapNewOffsetToOld(newOffset);
        int oldLine = this.oldLineManager.getLineAt(oldOffset);
        int oldColumn = oldOffset - this.oldLineManager.getLineStart(oldLine);
        return oldColumn;
    }

    public int mapNewOffsetToOld(int newOffset) {
        int start;
        Mask mask;
        int oldOffset = newOffset;
        for (int i = 0; i < this.masks.size() && oldOffset >= (start = (mask = (Mask)this.masks.get(i)).getStart()); oldOffset += mask.getLength(), ++i) {
        }
        return oldOffset;
    }

    void prepareLineMap() {
        int[] lineStarts = this.oldLineManager.lineStarts;
        int[] newLineStarts = new int[lineStarts.length];
        boolean currentNewLine = false;
        for (int i = 0; i < lineStarts.length; ++i) {
        }
    }

    static class LineManager {
        int[] lineStarts = new int[0];
        int textLength;

        LineManager() {
        }

        void compute(String text) {
            this.textLength = text.length();
            this.lineStarts = LineManager.computeLineStarts(text);
        }

        int getLineCount() {
            return this.lineStarts.length;
        }

        int getOffset(int line, int column) {
            return this.getLineStart(line) + column;
        }

        public int getLineAt(int index) {
            int toRet = this.lineStarts.length - 1;
            for (int i = 0; i < this.lineStarts.length; ++i) {
                int lineStart = this.lineStarts[i];
                if (lineStart <= index) continue;
                toRet = i - 1;
                break;
            }
            return toRet;
        }

        public int getLineStart(int line) {
            if (line < 0) {
                return 0;
            }
            if (line < this.lineStarts.length) {
                return this.lineStarts[line];
            }
            return this.textLength;
        }

        public int getLineEnd(int line) {
            if (line < 0) {
                return 0;
            }
            if (line < this.lineStarts.length - 1) {
                return this.lineStarts[line + 1];
            }
            return this.textLength;
        }

        private static int[] computeLineStarts(String text) {
            int lineCount = 0;
            int[] lineStarts = new int[1000];
            lineStarts[lineCount++] = 0;
            int length = text.length();
            for (int i = 0; i < length; ++i) {
                int lineStart;
                char b = text.charAt(i);
                if (b == '\r') {
                    lineStart = i + 1;
                    if (i >= length - 1 || text.charAt(++i) != '\n') continue;
                    lineStarts = LineManager.resize(lineStarts, lineCount);
                    lineStarts[lineCount++] = ++lineStart;
                    continue;
                }
                if (b != '\n') continue;
                lineStart = i + 1;
                lineStarts = LineManager.resize(lineStarts, lineCount);
                lineStarts[lineCount++] = lineStart;
            }
            return Arrays.copyOf(lineStarts, lineCount);
        }

        private static int[] resize(int[] lineStarts, int lineCount) {
            if (lineStarts.length - lineCount < 10) {
                return Arrays.copyOf(lineStarts, lineStarts.length * 2);
            }
            return lineStarts;
        }
    }
}

