/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.util.io;

import com.tplus.transform.util.io.FileInfo;
import com.tplus.transform.util.io.FileSystemInternal;

public abstract class AbstractFileInfo
implements FileInfo {
    private String name;
    private String qName;
    private FileSystemInternal fileSystem;

    public AbstractFileInfo(String qName, String name, FileSystemInternal fileSystem) {
        this.qName = qName;
        this.name = name;
        this.fileSystem = fileSystem;
    }

    public String getName() {
        return this.name;
    }

    public String getQualifiedName() {
        return this.qName;
    }

    public FileInfo getParent() {
        return this.fileSystem.getParent(this);
    }

    public boolean isDirectory() {
        return this.fileSystem.isDirectory(this);
    }

    public FileInfo[] listFiles() {
        return this.fileSystem.listFiles(this);
    }

    public boolean createDirectory() {
        return this.fileSystem.createDirectory(this);
    }

    public boolean deleteDirectory() {
        return this.fileSystem.deleteDirectory(this);
    }

    public boolean delete() {
        return this.fileSystem.delete(this);
    }

    public boolean exists() {
        return this.fileSystem.exists(this);
    }

    public int compareTo(Object o) {
        FileInfo fileInfo = (FileInfo)o;
        return this.qName.compareTo(fileInfo.getQualifiedName());
    }

    public String toString() {
        return this.qName;
    }

    public boolean equals(Object obj) {
        if (obj instanceof AbstractFileInfo) {
            AbstractFileInfo fileInfo = (AbstractFileInfo)obj;
            return this.qName.equals(fileInfo.qName);
        }
        return false;
    }

    public int hashCode() {
        return this.qName.hashCode();
    }
}

