/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.util.log;

public interface Log {
    public static final LogLevel OFF = new LogLevel("OFF");
    public static final LogLevel FATAL = new LogLevel("FATAL");
    public static final LogLevel ERROR = new LogLevel("ERROR");
    public static final LogLevel WARN = new LogLevel("WARN");
    public static final LogLevel INFO = new LogLevel("INFO");
    public static final LogLevel DEBUG = new LogLevel("DEBUG");
    public static final LogLevel TRACE = new LogLevel("TRACE");
    public static final LogLevel ALL = new LogLevel("ALL");

    public boolean isDebugEnabled();

    public boolean isErrorEnabled();

    public boolean isFatalEnabled();

    public boolean isInfoEnabled();

    public boolean isTraceEnabled();

    public boolean isWarnEnabled();

    public void trace(Object var1);

    public void trace(Object var1, Throwable var2);

    public void traceFormatted(String var1, Object[] var2);

    public void trace(String var1, Object var2, Throwable var3);

    public void debug(Object var1);

    public void debug(Object var1, Throwable var2);

    public void debug(String var1, Object var2, Throwable var3);

    public void debugFormatted(String var1, Object[] var2);

    public void info(Object var1);

    public void info(Object var1, Throwable var2);

    public void info(String var1, Object var2, Throwable var3);

    public void infoFormatted(String var1, Object[] var2);

    public void warn(Object var1);

    public void warn(Object var1, Throwable var2);

    public void warn(String var1, Object var2, Throwable var3);

    public void warnFormatted(String var1, Object[] var2);

    public void error(Object var1);

    public void error(Object var1, Throwable var2);

    public void error(String var1, Object var2, Throwable var3);

    public void errorFormatted(String var1, Object[] var2);

    public void fatal(Object var1);

    public void fatal(Object var1, Throwable var2);

    public void fatal(String var1, Object var2, Throwable var3);

    public void fatalFormatted(String var1, Object[] var2);

    public void log(Object var1, LogLevel var2, Throwable var3);

    public void unexpectedError(Throwable var1);

    public void remotingError(Throwable var1);

    public void setLevel(LogLevel var1);

    public static class LogLevel {
        private static final String ALL_NAME = "ALL";
        private static final String TRACE_NAME = "TRACE";
        private static final String DEBUG_NAME = "DEBUG";
        private static final String INFO_NAME = "INFO";
        private static final String WARN_NAME = "WARN";
        private static final String ERROR_NAME = "ERROR";
        private static final String FATAL_NAME = "FATAL";
        private static final String OFF_NAME = "OFF";
        private String levelStr;

        public LogLevel(String levelStr) {
            this.levelStr = levelStr;
        }

        public String toString() {
            return this.levelStr;
        }

        public static LogLevel toLogLevel(String level) {
            if (level == null) {
                return OFF;
            }
            String levelString = level.trim().toUpperCase();
            if (TRACE_NAME.equals(levelString)) {
                return TRACE;
            }
            if (DEBUG_NAME.equals(levelString)) {
                return DEBUG;
            }
            if (INFO_NAME.equals(levelString)) {
                return INFO;
            }
            if (WARN_NAME.equals(levelString)) {
                return WARN;
            }
            if (ERROR_NAME.equals(levelString)) {
                return ERROR;
            }
            if (FATAL_NAME.equals(levelString)) {
                return FATAL;
            }
            return OFF;
        }
    }
}

