/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.util.log;

import com.tplus.transform.util.log.AbstractLogger;
import com.tplus.transform.util.log.Log;

public class SimpleLog
extends AbstractLogger {
    private String name;
    private static final String ERROR = "ERROR";
    private static final Object DEBUG = "DEBUG";
    private static final Object INFO = "INFO";
    private static final Object WARN = "WARN";
    private static final Object FATAL = "FATAL";

    public SimpleLog(String name) {
        this.name = name;
    }

    public boolean isDebugEnabled() {
        return false;
    }

    public boolean isErrorEnabled() {
        return true;
    }

    public boolean isFatalEnabled() {
        return true;
    }

    public boolean isInfoEnabled() {
        return false;
    }

    public boolean isTraceEnabled() {
        return false;
    }

    public boolean isWarnEnabled() {
        return true;
    }

    public void trace(Object object, Throwable throwable) {
    }

    public void debug(Object object, Throwable throwable) {
    }

    public void info(Object object, Throwable throwable) {
    }

    public void warn(Object object, Throwable throwable) {
        this.log(WARN, object, throwable);
    }

    public void error(Object object, Throwable throwable) {
        this.log((Object)ERROR, object, throwable);
    }

    public void fatal(Object object, Throwable throwable) {
        this.log(FATAL, object, throwable);
    }

    public void setLevel(Log.LogLevel level) {
    }

    private void log(Object severity, Object object, Throwable throwable) {
        System.out.println("[" + severity + "]" + object);
        if (throwable != null) {
            throwable.printStackTrace();
        }
    }
}

