/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.util.log.osgi;

import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.service.log.LogService;

class OSGIServiceLogger {
    private ServiceReference s_serviceref = null;
    private LogService s_logservice = null;
    private ServiceListener s_servlistener;
    private Bundle bundle;

    OSGIServiceLogger() {
    }

    public void initOSGI(Class cls) {
        Bundle bundle = FrameworkUtil.getBundle((Class)cls);
        if (bundle != null) {
            this.initOSGI(bundle);
        }
    }

    public void initOSGI(Bundle bundle) {
        this.initOSGI(bundle, null);
    }

    public void initOSGI(Bundle bundle, ServiceReference servref) {
        this.s_serviceref = servref;
        this.s_servlistener = new LogServiceListener(bundle);
        this.bundle = bundle;
        this.register();
    }

    private void register() {
        BundleContext context = this.bundle.getBundleContext();
        if (context != null) {
            try {
                String filter = "(objectclass=" + LogService.class.getName() + ")";
                context.addServiceListener(this.s_servlistener, filter);
            }
            catch (InvalidSyntaxException e) {
                e.printStackTrace();
            }
            ServiceReference ref = context.getServiceReference(LogService.class.getName());
            if (ref != null) {
                this.s_logservice = (LogService)context.getService(ref);
            }
        }
    }

    public LogService getLogService() {
        if (this.s_logservice == null) {
            this.register();
        }
        return this.s_logservice;
    }

    public ServiceReference getServiceReference() {
        return this.s_serviceref;
    }

    public void setLogService(LogService logservice) {
        this.s_logservice = logservice;
    }

    public void setServiceReference(ServiceReference ref) {
        this.s_serviceref = ref;
    }

    class LogServiceListener
    implements ServiceListener {
        private Bundle bundle;

        LogServiceListener(Bundle bundle) {
            this.bundle = bundle;
        }

        public void serviceChanged(ServiceEvent event) {
            LogService ls;
            BundleContext bundleContext = this.bundle.getBundleContext();
            if (bundleContext != null && (ls = (LogService)bundleContext.getService(event.getServiceReference())) != null) {
                if (event.getType() == 1) {
                    OSGIServiceLogger.this.setLogService(ls);
                } else if (event.getType() == 4 && ls.equals(OSGIServiceLogger.this.s_logservice)) {
                    OSGIServiceLogger.this.setLogService(null);
                    ServiceReference ref = bundleContext.getServiceReference(LogService.class.getName());
                    if (ref != null) {
                        OSGIServiceLogger.this.s_logservice = (LogService)bundleContext.getService(ref);
                    }
                }
            }
        }
    }
}

