/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.util.log.osgi;

import com.tplus.transform.util.log.AbstractLogger;
import com.tplus.transform.util.log.Log;
import com.tplus.transform.util.log.osgi.OSGIServiceLogger;
import org.osgi.framework.ServiceReference;
import org.osgi.service.log.LogService;

public class OSGiLogger
extends AbstractLogger {
    public static final boolean DEBUG_ENABLED = false;
    private String name;
    private final OSGIServiceLogger osgiServiceLogger;
    private static final long serialVersionUID = 1L;

    public OSGiLogger(String name, OSGIServiceLogger osgiServiceLogger) {
        this.name = name;
        this.osgiServiceLogger = osgiServiceLogger;
    }

    private final void logImpl(int level, Object message, Throwable t) {
        message = OSGiLogger.sanitizeMessage(message);
        LogService logservice = this.osgiServiceLogger.getLogService();
        ServiceReference serviceref = this.osgiServiceLogger.getServiceReference();
        if (logservice != null) {
            try {
                if (t != null) {
                    logservice.log(serviceref, level, message.toString(), t);
                } else {
                    logservice.log(serviceref, level, message.toString());
                }
            }
            catch (Exception exc) {
                // empty catch block
            }
        }
    }

    public boolean isTraceEnabled() {
        return false;
    }

    public void trace(Object msg, Throwable t) {
        this.logImpl(4, msg, t);
    }

    public boolean isDebugEnabled() {
        return false;
    }

    public void debug(Object msg) {
        this.logImpl(4, msg, null);
    }

    public void debug(Object msg, Throwable t) {
        this.logImpl(4, msg, t);
    }

    public boolean isInfoEnabled() {
        return true;
    }

    public void info(Object msg, Throwable throwable) {
        this.logImpl(3, msg, throwable);
    }

    public boolean isWarnEnabled() {
        return true;
    }

    public void warn(Object msg, Throwable throwable) {
        this.logImpl(2, msg, throwable);
    }

    public boolean isErrorEnabled() {
        return true;
    }

    public void error(Object msg, Throwable throwable) {
        this.logImpl(1, msg, throwable);
    }

    public boolean isFatalEnabled() {
        return true;
    }

    public void fatal(Object msg, Throwable throwable) {
        this.logImpl(1, msg, throwable);
    }

    public void setLevel(Log.LogLevel level) {
    }
}

