/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.util.xml;

import com.tplus.transform.util.xml.NamespaceContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class NamespaceContextImpl
implements NamespaceContext {
    private String[] nsBind = new String[16];
    private int nsLen = 0;

    public void startPrefixMapping(String prefix, String uri) {
        if (this.nsBind.length == this.nsLen) {
            String[] n = new String[this.nsLen * 2];
            System.arraycopy(this.nsBind, 0, n, 0, this.nsLen);
            this.nsBind = n;
        }
        this.nsBind[this.nsLen++] = prefix;
        this.nsBind[this.nsLen++] = uri;
    }

    public void endPrefixMapping(String prefix) {
        this.nsLen -= 2;
    }

    public void endPrefixMapping(int count) {
        this.nsLen -= count * 2;
    }

    public String resolveNamespacePrefix(String prefix) {
        for (int i = this.nsLen - 2; i >= 0; i -= 2) {
            if (!prefix.equals(this.nsBind[i])) continue;
            return this.nsBind[i + 1];
        }
        if (prefix.length() > 0) {
            if (prefix.equals("xmlns")) {
                return "http://www.w3.org/2000/xmlns/";
            }
            if (prefix.equals("xml")) {
                return "http://www.w3.org/XML/1998/namespace";
            }
        }
        return null;
    }

    public String getPrefix(String uri) {
        if (uri == null) {
            throw new IllegalArgumentException();
        }
        for (int i = this.nsLen - 2; i >= 0; i -= 2) {
            if (!uri.equals(this.nsBind[i + 1])) continue;
            return this.nsBind[i];
        }
        if (uri.length() > 0) {
            if (uri.equals("http://www.w3.org/XML/1998/namespace")) {
                return "xml";
            }
            if (uri.equals("http://www.w3.org/2000/xmlns/")) {
                return "xmlns";
            }
        }
        return null;
    }

    public String getNamespaceURI(String prefix) {
        if (prefix == null) {
            throw new IllegalArgumentException();
        }
        return this.resolveNamespacePrefix(prefix);
    }

    public Iterator getPrefixes(String uri) {
        return Collections.unmodifiableList(this.getAllPrefixesInList(uri)).iterator();
    }

    private List getAllPrefixesInList(String uri) {
        ArrayList<String> a = new ArrayList<String>();
        if (uri == null) {
            throw new IllegalArgumentException();
        }
        if (uri.equals("http://www.w3.org/XML/1998/namespace")) {
            a.add("xml");
            return a;
        }
        if (uri.equals("http://www.w3.org/2000/xmlns/")) {
            a.add("xmlns");
            return a;
        }
        for (int i = this.nsLen - 2; i >= 0; i -= 2) {
            if (!uri.equals(this.nsBind[i + 1]) || !this.getNamespaceURI(this.nsBind[i]).equals(this.nsBind[i + 1])) continue;
            a.add(this.nsBind[i]);
        }
        return a;
    }

    public void clear() {
        this.nsLen = 0;
    }
}

