/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.util.xml;

import com.tplus.transform.io.SafeFile;
import com.tplus.transform.util.StringUtils;
import com.tplus.transform.util.log.Log;
import com.tplus.transform.util.log.LogFactory;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XMLUtils {
    protected static Log log = LogFactory.getLog(XMLUtils.class);
    private static final String CDATA_START = "<![CDATA[";
    private static final String CDATA_END = "]]>";
    protected static final String EXTERNAL_ENTITIES_FEATURE = "http://xml.org/sax/features/external-general-entities";
    protected static final String EXTERNAL_PARAM_ENTITIES_FEATURE = "http://xml.org/sax/features/external-parameter-entities";
    protected static final String EXTERNAL_DTD_LOADING_FEATURE = "http://apache.org/xml/features/nonvalidating/load-external-dtd";
    static DocumentBuilderFactory docBuilderFactoryNS;
    static DocumentBuilderFactory docBuilderFactory;
    public static final int doubleQuoteAttribute = 1;
    public static final int singleQuoteAttribute = 2;
    public static final int Attribute = 3;
    public static final int Element = 0;
    public static final String xmlstdFldPrefix = "F";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Document createDocument(String fileName, boolean ns) throws SAXException, IOException, ParserConfigurationException {
        SafeFile.doFileCheck(fileName);
        BufferedInputStream is = new BufferedInputStream(new FileInputStream(fileName));
        try {
            if (ns) {
                Document document = XMLUtils.createDocumentNS(is);
                return document;
            }
            Document document = XMLUtils.createDocument(is);
            return document;
        }
        finally {
            is.close();
        }
    }

    public static Document createDocumentNS(InputStream is) throws SAXException, IOException, ParserConfigurationException {
        InputSource inputSource = XMLUtils.createInputSource(is);
        return XMLUtils.createDocumentNS(inputSource);
    }

    public static Document createDocumentTryNS(String fileName) throws SAXException, IOException, ParserConfigurationException {
        try {
            return XMLUtils.createDocumentNS(fileName);
        }
        catch (SAXException e) {
            log.warn("Error parsing " + fileName + " namespaces enabled");
            return XMLUtils.createDocument(fileName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Document createDocumentNS(String fileName) throws SAXException, IOException, ParserConfigurationException {
        SafeFile.doFileCheck(fileName);
        BufferedInputStream is = new BufferedInputStream(new FileInputStream(fileName));
        try {
            InputSource inputSource = new InputSource(is);
            Document document = XMLUtils.createDocument(inputSource, true);
            return document;
        }
        finally {
            is.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Document createDocument(String fileName) throws SAXException, IOException, ParserConfigurationException {
        SafeFile.doFileCheck(fileName);
        BufferedInputStream is = new BufferedInputStream(new FileInputStream(fileName));
        try {
            Document document = XMLUtils.createDocument(is);
            return document;
        }
        finally {
            is.close();
        }
    }

    private static InputSource createInputSource(InputStream is) {
        InputSource inputSource = new InputSource(is);
        return inputSource;
    }

    public static Document createDocument(InputStream is) throws SAXException, IOException, ParserConfigurationException {
        InputSource inputSource = new InputSource(is);
        return XMLUtils.createDocument(inputSource);
    }

    private static Document createDocumentNS(InputSource inputSource) throws ParserConfigurationException, SAXException, IOException {
        return XMLUtils.createDocument(inputSource, true);
    }

    private static synchronized DocumentBuilder createBuilder(boolean ns) throws ParserConfigurationException {
        if (ns) {
            if (docBuilderFactoryNS == null) {
                docBuilderFactoryNS = XMLUtils.create(ns);
            }
            return docBuilderFactoryNS.newDocumentBuilder();
        }
        if (docBuilderFactory == null) {
            docBuilderFactory = XMLUtils.create(ns);
        }
        return docBuilderFactory.newDocumentBuilder();
    }

    private static DocumentBuilderFactory create(boolean ns) {
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        docBuilderFactory.setNamespaceAware(ns);
        XMLUtils.disableExternalEntity(docBuilderFactory);
        return docBuilderFactory;
    }

    public static void disableExternalEntity(DocumentBuilderFactory docBuilderFactory) {
        try {
            docBuilderFactory.setFeature(EXTERNAL_ENTITIES_FEATURE, false);
            docBuilderFactory.setFeature(EXTERNAL_PARAM_ENTITIES_FEATURE, false);
            docBuilderFactory.setFeature(EXTERNAL_DTD_LOADING_FEATURE, false);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            // empty catch block
        }
    }

    private static Document createDocument(InputSource inputSource, boolean ns) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilder docBuilder = XMLUtils.createBuilder(ns);
        docBuilder.setEntityResolver(new EntityResolver(){

            public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                return new InputSource(new StringReader(""));
            }
        });
        Document doc = docBuilder.parse(inputSource);
        return doc;
    }

    private static Document createDocument(InputSource inputSource) throws ParserConfigurationException, SAXException, IOException {
        return XMLUtils.createDocument(inputSource, false);
    }

    public static Document createDocument(Reader reader) throws SAXException, IOException, ParserConfigurationException {
        InputSource inputSource = new InputSource(reader);
        return XMLUtils.createDocument(inputSource);
    }

    public static Element getSingleChildElement(Element parent, String tagName) {
        Element singleChild = null;
        for (Node child = parent.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!(child instanceof Element) || !child.getNodeName().equals(tagName)) continue;
            singleChild = (Element)child;
            break;
        }
        return singleChild;
    }

    public static Element getSingleChildElementWithAttrib(Element parent, String tagName, String attrib, String attribValue) {
        Element singleChild = null;
        NodeList lst = parent.getChildNodes();
        int length = lst.getLength();
        for (int i = 0; i < length; ++i) {
            Node nd = lst.item(i);
            if (!(nd instanceof Element)) continue;
            Element elm = (Element)nd;
            if (!nd.getNodeName().equals(tagName) || !elm.getAttribute(attrib).equals(attribValue)) continue;
            singleChild = elm;
            break;
        }
        return singleChild;
    }

    public static Element getNextElement(Element sibling, String tagName) {
        Element singleChild = null;
        Node current = sibling;
        while (current != null) {
            Node nextNode = current.getNextSibling();
            if (nextNode instanceof Element && nextNode.getNodeName().equals(tagName)) {
                singleChild = (Element)nextNode;
                break;
            }
            current = nextNode;
        }
        return singleChild;
    }

    public static String getSingleChildElementValue(Element parent, String tagName) {
        Element childElm = XMLUtils.getSingleChildElement(parent, tagName);
        if (childElm != null) {
            return XMLUtils.getElementText(childElm);
        }
        return null;
    }

    public static String getSingleChildElementValueWithAlias(Element parent, String tagName1, String tagName2) {
        Element childElm = XMLUtils.getSingleChildElement(parent, tagName1);
        if (childElm != null) {
            return XMLUtils.getElementText(childElm);
        }
        return XMLUtils.getSingleChildElementValue(parent, tagName2);
    }

    public static String getSingleChildElementValue(Element parent, String tagName, String defaultValue) {
        Element childElm = XMLUtils.getSingleChildElement(parent, tagName);
        if (childElm != null) {
            return XMLUtils.getElementText(childElm);
        }
        return defaultValue;
    }

    public static Element getSingleChildElement(Element parent, String tagName, String tagName2) {
        Element elm = XMLUtils.getSingleChildElement(parent, tagName);
        if (elm == null) {
            elm = XMLUtils.getSingleChildElement(parent, tagName2);
        }
        return elm;
    }

    public static String getNormalizedSingleChildElementValue(Element parent, String tagName) {
        String toRet = XMLUtils.getSingleChildElementValue(parent, tagName);
        return XMLUtils.normalize(toRet);
    }

    public static int getSingleChildElementIntValue(Element parent, String tagName, int defaultValue) {
        String ret = XMLUtils.getNormalizedSingleChildElementValue(parent, tagName);
        if (ret == null) {
            return defaultValue;
        }
        return Integer.parseInt(ret);
    }

    public static boolean getSingleChildElementBooleanValue(Element parent, String tagName, boolean defaultValue) {
        String ret = XMLUtils.getNormalizedSingleChildElementValue(parent, tagName);
        if (ret == null) {
            return defaultValue;
        }
        return Boolean.valueOf(ret);
    }

    public static String normalize(String value) {
        if (value != null) {
            return value.trim();
        }
        return value;
    }

    public static String getElementText(Node elm) {
        String nodeValue = "";
        for (Node text = elm.getFirstChild(); text != null; text = text.getNextSibling()) {
            short nodeType = text.getNodeType();
            if (nodeType != 4 && nodeType != 3) continue;
            nodeValue = nodeValue.length() == 0 ? text.getNodeValue() : nodeValue + text.getNodeValue();
        }
        return nodeValue;
    }

    public static NodeList getChildElementsByTagName(Element elm, String tag) {
        SimpleNodeList nodeList = new SimpleNodeList();
        for (Node child = elm.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!(child instanceof Element) || !child.getNodeName().equals(tag)) continue;
            nodeList.add(child);
        }
        return nodeList;
    }

    public static String getSingleChildElementValueNS(Element parent, String tagName, String namespace) {
        Element childElm = XMLUtils.getSingleChildElementNS(parent, tagName, namespace);
        if (childElm != null) {
            return XMLUtils.getElementText(childElm);
        }
        return null;
    }

    public static Element getSingleChildElementNS(Element parent, String tagName, String namespace) {
        Element singleChild = null;
        for (Node child = parent.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!(child instanceof Element)) continue;
            String nodeName = child.getNodeName();
            String t1 = child.getLocalName();
            if (!StringUtils.equals(t1, tagName) || !XMLUtils.namespaceEquals(child.getNamespaceURI(), namespace)) continue;
            singleChild = (Element)child;
            break;
        }
        return singleChild;
    }

    public static NodeList getChildElementsByTagNameNS(Element elm, String tag, String namespace) {
        SimpleNodeList nodeList = new SimpleNodeList();
        for (Node child = elm.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!(child instanceof Element)) continue;
            Element element = (Element)child;
            String t1 = element.getLocalName();
            String n1 = child.getNamespaceURI();
            if (!t1.equals(tag) || !XMLUtils.namespaceEquals(n1, namespace)) continue;
            nodeList.add(child);
        }
        return nodeList;
    }

    private static boolean namespaceEquals(String namespaceURI, String namespace) {
        return StringUtils.equals(namespaceURI, namespace);
    }

    public static NodeList getChildElementsByTagName(Element elm, String tag, String tag2) {
        NodeList list = XMLUtils.getChildElementsByTagName(elm, tag);
        if (list.getLength() == 0) {
            list = XMLUtils.getChildElementsByTagName(elm, tag2);
        }
        return list;
    }

    public static NodeList getChildElementsByTagName(Element elm, String[] tags) {
        SimpleNodeList nodeList = new SimpleNodeList();
        NodeList lst = elm.getChildNodes();
        int length = lst.getLength();
        block0: for (int i = 0; i < length; ++i) {
            Node nd = lst.item(i);
            for (int j = 0; j < tags.length; ++j) {
                if (!(nd instanceof Element) || !nd.getNodeName().equals(tags[j])) continue;
                nodeList.add(nd);
                continue block0;
            }
        }
        return nodeList;
    }

    public static NodeList getChildElements(Element elm) {
        SimpleNodeList nodeList = new SimpleNodeList();
        NodeList lst = elm.getChildNodes();
        int length = lst.getLength();
        for (int i = 0; i < length; ++i) {
            Node nd = lst.item(i);
            if (!(nd instanceof Element)) continue;
            nodeList.add(nd);
        }
        return nodeList;
    }

    public static boolean hasNonXMLCharacters(String toWrite) {
        if (toWrite == null) {
            return false;
        }
        int length = toWrite.length();
        for (int i = 0; i < length; ++i) {
            char c = toWrite.charAt(i);
            if (c == '<' || c == '>' || c == '&' || c == '\'' || c == '\"') {
                return true;
            }
            if (c >= ' ' && c <= '\u007f' || c == '\r' || c == '\n' || c == '\t') continue;
            return true;
        }
        return false;
    }

    public static String fixXMLCharData(String str) {
        return XMLUtils.replaceXMLEntities(str, false);
    }

    public static String fixXMLAttribute(String str) {
        return XMLUtils.replaceXMLEntities(str, true);
    }

    public static String fixXMLAttributeDoubleQuoted(String str) {
        return XMLUtils.replaceXMLEntities(str, 1);
    }

    public static String fixXMLContent(String str) {
        return XMLUtils.replaceXMLEntities(str);
    }

    public static String replaceXMLEntities(String toWrite, boolean attribute) {
        return XMLUtils.replaceXMLEntities(toWrite, attribute ? 3 : 0);
    }

    public static String replaceXMLEntities(String toWrite, int attribute) {
        if (!XMLUtils.hasNonXMLCharacters(toWrite)) {
            return toWrite;
        }
        StringBuffer toRet = new StringBuffer();
        int length = toWrite.length();
        block7: for (int i = 0; i < length; ++i) {
            char c = toWrite.charAt(i);
            switch (c) {
                case '<': {
                    toRet.append("&lt;");
                    continue block7;
                }
                case '>': {
                    toRet.append("&gt;");
                    continue block7;
                }
                case '&': {
                    toRet.append("&amp;");
                    continue block7;
                }
                case '\'': {
                    if ((attribute & 2) == 0) break;
                    toRet.append("&apos;");
                    continue block7;
                }
                case '\"': {
                    if ((attribute & 1) == 0) break;
                    toRet.append("&quot;");
                    continue block7;
                }
                default: {
                    if (c >= ' ' && c <= '\u007f' || c == '\r' || c == '\n' || c == '\t') break;
                    if (c < '\t') {
                        toRet.append(" ");
                        continue block7;
                    }
                    toRet.append("&#").append((int)c).append(";");
                    continue block7;
                }
            }
            toRet.append(c);
        }
        return toRet.toString();
    }

    public static String replaceXMLEntities(String toWrite) {
        if (!XMLUtils.hasNonXMLCharacters(toWrite)) {
            return toWrite;
        }
        StringBuffer toRet = new StringBuffer();
        int length = toWrite.length();
        block7: for (int i = 0; i < length; ++i) {
            char c = toWrite.charAt(i);
            switch (c) {
                case '<': {
                    toRet.append("&lt;");
                    continue block7;
                }
                case '>': {
                    toRet.append("&gt;");
                    continue block7;
                }
                case '&': {
                    toRet.append("&amp;");
                    continue block7;
                }
                case '\'': {
                    toRet.append("&apos;");
                    continue block7;
                }
                case '\"': {
                    toRet.append("&quot;");
                    continue block7;
                }
                default: {
                    if ((c < ' ' || c > '\u007f') && c != '\r' && c != '\n' && c != '\t') {
                        toRet.append("&#").append((int)c).append(";");
                        continue block7;
                    }
                    toRet.append(c);
                }
            }
        }
        return toRet.toString();
    }

    private static boolean hasWindowsCharacters(String toWrite) {
        int length = toWrite.length();
        for (int i = 0; i < length; ++i) {
            char c = toWrite.charAt(i);
            if (c >= ' ' && c <= '\u007f' || c == '\r' || c == '\n' || c == '\t') continue;
            return true;
        }
        return false;
    }

    static char getASCIIEquivalent(char c) {
        switch (c) {
            case '\u201c': 
            case '\u201d': {
                return '\"';
            }
            case '\u2018': 
            case '\u2019': {
                return '\'';
            }
            case '\u2013': {
                return '-';
            }
            case '\u00e1': {
                return 'a';
            }
            case '\u00b7': {
                return '.';
            }
            case '\u00a2': {
                return '$';
            }
        }
        return c;
    }

    public static String CDATAValue(String toWrite) {
        if (!XMLUtils.hasNonXMLCharacters(toWrite)) {
            return toWrite;
        }
        int cdataEndIndex = toWrite.indexOf(CDATA_END);
        if (cdataEndIndex != -1) {
            StringBuffer toRet = new StringBuffer();
            String remain = toWrite;
            while (cdataEndIndex != -1) {
                String top = remain.substring(0, cdataEndIndex + 2);
                toRet.append(CDATA_START).append(top).append(CDATA_END);
                remain = remain.substring(cdataEndIndex + 2);
                cdataEndIndex = remain.indexOf(CDATA_END);
            }
            toRet.append(CDATA_START).append(remain).append(CDATA_END);
            return toRet.toString();
        }
        return CDATA_START + toWrite + CDATA_END;
    }

    public static String CDATAValueSpecial(String toWrite) {
        int cdataEndIndex = (toWrite = XMLUtils.fixWindowsCharacters(toWrite)).indexOf(CDATA_END);
        if (cdataEndIndex != -1) {
            StringBuffer toRet = new StringBuffer();
            String remain = toWrite;
            while (cdataEndIndex != -1) {
                String top = remain.substring(0, cdataEndIndex + 2);
                toRet.append(CDATA_START).append(top).append(CDATA_END);
                remain = remain.substring(cdataEndIndex + 2);
                cdataEndIndex = remain.indexOf(CDATA_END);
            }
            toRet.append(CDATA_START).append(remain).append(CDATA_END);
            return toRet.toString();
        }
        return CDATA_START + toWrite + CDATA_END;
    }

    private static String fixWindowsCharacters(String toWrite) {
        if (XMLUtils.hasWindowsCharacters(toWrite)) {
            int length = toWrite.length();
            StringBuffer toRet = new StringBuffer();
            for (int i = 0; i < length; ++i) {
                char c = toWrite.charAt(i);
                if ((c < ' ' || c > '\u007f') && c != '\r' && c != '\n' && c != '\t') {
                    c = XMLUtils.getASCIIEquivalent(c);
                }
                toRet.append(c);
            }
            toWrite = toRet.toString();
        }
        return toWrite;
    }

    static boolean hasXMLInvalidCharacters(String fldName) {
        if (fldName.length() == 0 || !Character.isJavaIdentifierStart(fldName.charAt(0))) {
            return true;
        }
        for (int i = 0; i < fldName.length(); ++i) {
            char c = fldName.charAt(i);
            if (Character.isJavaIdentifierPart(c) && c != '$') continue;
            return true;
        }
        return false;
    }

    public static String computeXMLName(String fldName) {
        if (!XMLUtils.hasXMLInvalidCharacters(fldName)) {
            return fldName;
        }
        StringBuffer out = new StringBuffer(fldName.length() + 6);
        if (fldName.length() == 0 || !Character.isJavaIdentifierStart(fldName.charAt(0))) {
            out.append(xmlstdFldPrefix);
        }
        for (int i = 0; i < fldName.length(); ++i) {
            char c = fldName.charAt(i);
            if (!Character.isJavaIdentifierPart(c) || c == '$') {
                c = '_';
            }
            out.append(c);
        }
        return out.toString();
    }

    public static class SimpleNodeList
    extends ArrayList
    implements NodeList {
        public void add(Node elm) {
            super.add(elm);
        }

        public Node item(int index) {
            return (Node)super.get(index);
        }

        public int getLength() {
            return super.size();
        }
    }
}

