/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.util.xml;

import com.tplus.transform.util.StringUtils;
import com.tplus.transform.util.xml.XMLUtils;
import java.util.Arrays;
import java.util.Set;
import java.util.TreeSet;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XPathUtils {
    static final Set singleNodeSet = new TreeSet(String.CASE_INSENSITIVE_ORDER);

    public static String getRelativePath(Node source, Node destination, boolean useNodePosition, boolean useParent) {
        Node parent;
        Node commonAncestor = XPathUtils.getCommonAncestor(source, destination);
        StringBuffer relativePath = new StringBuffer();
        Node fieldSideSibling = null;
        for (parent = destination; commonAncestor != parent && parent != null; parent = parent.getParentNode()) {
            String nodeName = useNodePosition ? XPathUtils.getNodeNameAbsolute(parent) : XPathUtils.getNodeName(parent);
            if (relativePath.length() > 0) {
                nodeName = nodeName + "/";
            }
            if (!useParent && parent.getParentNode() == commonAncestor && commonAncestor != source) {
                fieldSideSibling = parent;
                break;
            }
            relativePath.insert(0, nodeName);
            Document ownerDocument = parent.getOwnerDocument();
            if (parent == null || ownerDocument != null && ownerDocument != parent) continue;
            break;
        }
        parent = source;
        StringBuffer relativeParentBuffer = new StringBuffer();
        if (parent == null) {
            relativeParentBuffer.append("/");
        }
        while (commonAncestor != parent && parent != null) {
            if (!useParent && parent.getParentNode() == commonAncestor && fieldSideSibling != null) {
                int position = XPathUtils.getRelativeNodeSiblingPosition(parent, fieldSideSibling);
                String positionStr = "[" + Math.abs(position) + "]";
                if (!useNodePosition) {
                    positionStr = "";
                }
                String nodeName = position > 0 ? "following-sibling::" + XPathUtils.getNodeName(fieldSideSibling) + positionStr : "preceding-sibling::" + XPathUtils.getNodeName(fieldSideSibling) + positionStr;
                relativeParentBuffer.append(nodeName).append("/");
                break;
            }
            relativeParentBuffer.append("../");
            parent = parent.getParentNode();
        }
        relativePath.insert(0, relativeParentBuffer.toString());
        String s = relativePath.toString();
        if (s.endsWith("/")) {
            s = s.substring(0, s.length() - 1);
        }
        if (s.length() == 0) {
            s = ".";
        }
        return s;
    }

    public static Node getCommonAncestor(Node df1, Node df2) {
        for (Node d1 = df1; d1 != null; d1 = d1.getParentNode()) {
            for (Node d2 = df2; d2 != null; d2 = d2.getParentNode()) {
                if (d1 != d2) continue;
                return d1;
            }
        }
        return null;
    }

    public static String getNodeText(Node element) {
        return XPathUtils.getElementText(element);
    }

    public static String getElementText(Node elm) {
        String nodeValue = null;
        for (Node text = elm.getFirstChild(); text != null; text = text.getNextSibling()) {
            if (text.getNodeType() != 3) continue;
            String nodeValue1 = text.getNodeValue();
            nodeValue = nodeValue == null ? nodeValue1 : nodeValue + nodeValue1;
        }
        return nodeValue;
    }

    public static String getNodePath(Node node) {
        StringBuffer toRet = new StringBuffer();
        while (node != null && node.getNodeType() != 9) {
            String name = XPathUtils.getNodeName(node);
            if (toRet.length() > 0) {
                toRet.insert(0, "/");
            }
            toRet.insert(0, name);
            node = node.getParentNode();
        }
        if (toRet.length() > 0) {
            toRet.insert(0, "/");
        }
        return toRet.toString();
    }

    public static String getAbsoluteNodePath(Node node) {
        StringBuffer toRet = new StringBuffer();
        while (node != null && node.getNodeType() != 9) {
            if (toRet.length() > 0) {
                toRet.insert(0, "/");
            }
            String name = XPathUtils.getNodeNameAbsolute(node);
            toRet.insert(0, name);
            node = node.getParentNode();
        }
        if (toRet.length() > 0) {
            toRet.insert(0, "/");
        }
        return toRet.toString();
    }

    public static Node getChildNode(Node root, String path) {
        String[] nodeNames = StringUtils.split(path, "/");
        Node current = root;
        String nodeName = nodeNames[1];
        String name = XPathUtils.getSimpleName(nodeName);
        int index = XPathUtils.getNodeIndex(nodeName);
        if (!XPathUtils.getNodeName(current).equals(name)) {
            return null;
        }
        for (int i = 2; i < nodeNames.length; ++i) {
            nodeName = nodeNames[i];
            name = XPathUtils.getSimpleName(nodeName);
            index = XPathUtils.getNodeIndex(nodeName);
            if (!(current instanceof Element)) continue;
            NodeList childElementsByTagName = XMLUtils.getChildElementsByTagName((Element)current, name);
            if (childElementsByTagName.getLength() < index) break;
            current = childElementsByTagName.item(index - 1);
        }
        return current;
    }

    private static String getSimpleName(String nodeName) {
        return StringUtils.leftStr(nodeName, "[");
    }

    private static int getNodeIndex(String nodeName) {
        if (nodeName.indexOf(91) != -1) {
            String s = StringUtils.midStr(nodeName, "[", "]");
            return Integer.parseInt(s);
        }
        return 0;
    }

    private static int getNodePosition(Node node) {
        return XPathUtils.getNodePosition(node.getParentNode(), node);
    }

    private static int getNodePosition(Node parentNode, Node node) {
        int index = -1;
        if (node == null || parentNode == null) {
            return -1;
        }
        String nodeName = XPathUtils.getNodeName(node);
        NodeList childNodes = parentNode.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node item = childNodes.item(i);
            if (nodeName.equals(XPathUtils.getNodeName(item))) {
                ++index;
            }
            if (item != node) continue;
            return index;
        }
        return -1;
    }

    private static int getRelativeNodeSiblingPosition(Node sibling1, Node sibling2) {
        if (sibling1.getParentNode() != sibling2.getParentNode()) {
            throw new IllegalArgumentException("The two nodes are not siblings");
        }
        String nodeName = XPathUtils.getNodeName(sibling2);
        int nextIndex = 0;
        for (Node next = sibling1.getNextSibling(); next != null; next = next.getNextSibling()) {
            if (next == sibling2) {
                return nextIndex + 1;
            }
            if (!nodeName.equals(XPathUtils.getNodeName(next))) continue;
            ++nextIndex;
        }
        int previousIndex = 0;
        for (Node previous = sibling1.getPreviousSibling(); previous != null; previous = previous.getPreviousSibling()) {
            if (previous == sibling2) {
                return -(previousIndex + 1);
            }
            if (!nodeName.equals(XPathUtils.getNodeName(previous))) continue;
            ++previousIndex;
        }
        return -1;
    }

    private static String getNodeNameAbsolute(Node node) {
        String name = node.getNodeName();
        String localName = node.getLocalName();
        String uri = node.getNamespaceURI();
        int pos = XPathUtils.getNodePosition(node);
        if (singleNodeSet.contains(name)) {
            return name;
        }
        return name + "[" + (pos + 1) + "]";
    }

    private static String getNodeName(Node node) {
        String name = node.getNodeName();
        String localName = node.getLocalName();
        String uri = node.getNamespaceURI();
        return name;
    }

    public static boolean isAncestor(Node element, Node selection) {
        while (element != null) {
            if (element == selection) {
                return true;
            }
            element = element.getParentNode();
        }
        return false;
    }

    static {
        singleNodeSet.addAll(Arrays.asList("body", "html"));
    }
}

