/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.license;

import com.tplus.license.MachInfo;
import com.tplus.license.NetworkMachInfo;
import java.security.SecureRandom;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;

public class GenericMachInfo
extends MachInfo {
    public static final String VOL_MACHINE_INFO = "vol-machine-info";
    public static final String ID = "id";

    @Override
    public String getMachineInfo(String preferred) {
        String mach = NetworkMachInfo.getMachInfo(preferred);
        if (mach == null) {
            mach = GenericMachInfo.getOrCreateSoftwareMachineId();
        }
        return mach;
    }

    private static String getOrCreateSoftwareMachineId() {
        Preferences appNode = Preferences.userRoot().node(VOL_MACHINE_INFO);
        String machineId = appNode.get(ID, null);
        if (machineId == null) {
            machineId = new MachineKeyGen().generate();
            appNode.put(ID, machineId);
            try {
                appNode.flush();
            }
            catch (BackingStoreException e) {
                e.printStackTrace();
            }
        }
        return machineId;
    }

    public static void main(String[] args) throws BackingStoreException {
        System.out.println(GenericMachInfo.getOrCreateSoftwareMachineId());
    }

    static class MachineKeyGen {
        SecureRandom rnd = new SecureRandom();
        private static final int MAX_LENGTH = 16;

        MachineKeyGen() {
        }

        public String generate() {
            int i;
            StringBuffer data = new StringBuffer();
            for (i = 0; i < 16; ++i) {
                int codePoint = this.getCodePoint();
                char c = this.charFromCodePoint(codePoint);
                data.append(c);
            }
            for (i = data.length() - 4; i > 0; i -= 4) {
                data.insert(i, '-');
            }
            data.insert(0, "VOLA-");
            return data.toString();
        }

        private int getCodePoint() {
            int maxDigit = 36;
            int codePoint = this.rnd.nextInt(maxDigit);
            while (codePoint == 0 || codePoint == 24) {
                codePoint = this.rnd.nextInt(maxDigit);
            }
            return codePoint;
        }

        private char charFromCodePoint(int base36) {
            return base36 < 10 ? (char)(48 + base36) : (char)(65 + base36 - 10);
        }
    }
}

