/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.license;

import com.tplus.license.LicenseException;
import com.tplus.license.LicenseMessage;
import com.tplus.license.Validity;
import com.tplus.license.lg.wsclient.LicenseType;
import com.tplus.license.lg.wsclient.RuntimeLicenseType;
import com.tplus.transform.util.StringUtils;
import com.tplus.transform.util.log.Log;
import com.tplus.transform.util.log.LogFactory;
import com.tplus.util.misc.BASE64Decoder;
import com.tplus.util.misc.BASE64Encoder;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.GeneralSecurityException;
import java.security.KeyException;
import java.security.MessageDigest;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Random;

public class ProtectParam
implements Cloneable,
Serializable {
    protected static Log log = LogFactory.getLog(ProtectParam.class);
    private Calendar startDate;
    String machineInfo;
    private int product;
    private int major;
    private int minor;
    private int licenseCount;
    private Validity validity = new Validity();
    private String featureString;
    String productName;
    String clientId;
    String productKey;
    long licenseId = -1L;
    String licenseType;
    String authorizationType;
    String fromIP;
    String toIP;
    String dns;
    public static final String MACH_ID = "MACH_ID";
    public static final String IP_ADDRESS = "IP_ADDRESS";
    public static final String HOST_NAME = "HOST_NAME";

    public ProtectParam() {
    }

    public ProtectParam(int product, int major, int minor, String machineInfo) throws LicenseException {
        this.product = product;
        this.major = major;
        this.minor = minor;
        this.machineInfo = machineInfo;
        this.startDate = new GregorianCalendar();
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public String getFeatureString() {
        return this.featureString;
    }

    public void setFeatureString(String feature) {
        this.featureString = feature;
    }

    public void setProduct(int id) {
        this.product = id;
    }

    public void setStartDate(Calendar start) {
        this.startDate = start;
    }

    public void setValidTill(Calendar till) {
        this.validity = new Validity(till);
    }

    public void setValidAlways() {
        this.validity = new Validity();
    }

    public void setMajorVersion(int val) {
        this.major = val;
    }

    public void setMinorVersion(int val) {
        this.minor = val;
    }

    public void setLicenseCount(int val) {
        this.licenseCount = val;
    }

    public void setProductName(String s) {
        this.productName = s;
    }

    public void setClientId(String s) {
        this.clientId = s;
    }

    public void setProductKey(String productKey) {
        this.productKey = productKey;
    }

    public void setLicenseId(long id) {
        this.licenseId = id;
    }

    public Validity getValidity() {
        return this.validity;
    }

    public void setValidity(Validity validity) {
        this.validity = validity;
    }

    public Calendar getStartDate() {
        return this.startDate;
    }

    public int getProduct() {
        return this.product;
    }

    public String getProductName() {
        return this.productName;
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getProductKey() {
        return this.productKey;
    }

    public long getLicenseId() {
        return this.licenseId;
    }

    public int getLicenseCount() {
        return this.licenseCount;
    }

    public int getMajorVersion() {
        return this.major;
    }

    public int getMinorVersion() {
        return this.minor;
    }

    public String getVersion() {
        return this.major + "." + this.minor;
    }

    public String getMachineInfo() {
        return this.machineInfo;
    }

    public String getFromIP() {
        return this.fromIP;
    }

    public void setFromIP(String fromIP) {
        this.fromIP = fromIP;
    }

    public String getToIP() {
        return this.toIP;
    }

    public void setToIP(String toIP) {
        this.toIP = toIP;
    }

    public String getDns() {
        return this.dns;
    }

    public void setDns(String dns) {
        this.dns = dns;
    }

    public void setMachineInfo(String machineInfo) {
        this.machineInfo = machineInfo;
    }

    public String getLicenseType() {
        return this.licenseType;
    }

    public void setLicenseType(String type) {
        this.licenseType = type;
    }

    public String getAuthorizationType() {
        return this.authorizationType;
    }

    public void setAuthorizationType(String authorizationType) {
        this.authorizationType = authorizationType;
    }

    public String toString() {
        String s = "";
        if (this.startDate != null) {
            s = s + ", StartDate = " + this.toString(this.startDate) + " ";
        }
        s = s + ", productid = " + this.product + " ";
        s = s + ", version = " + this.major + "." + this.minor + "  ";
        if (this.productName != null) {
            s = s + ", Product =" + this.productName + " ";
        }
        if (this.productKey != null) {
            s = s + ", productKey =" + this.productKey + " ";
        }
        if (this.machineInfo != null) {
            s = s + ", machine = " + this.machineInfo + " ";
        }
        s = this.validity.getValidTill() != null ? s + ", validTill = " + this.toString(this.validity.getValidTill()) + " " : s + ", Permanent license ";
        if (this.validity.getRuns() != 0) {
            s = s + ", validRuns = " + this.validity.getRuns() + " ";
        }
        if (this.clientId != null) {
            s = s + ", Client id = " + this.clientId;
        }
        if (this.licenseId != -1L) {
            s = s + ", license id = " + this.licenseId;
        }
        if (this.featureString != null) {
            s = s + ", features = + " + this.featureString;
        }
        if (this.licenseType != null) {
            s = s + ", License Type = " + this.licenseType;
        }
        if (this.authorizationType != null) {
            s = s + ", Authorization Type = " + this.authorizationType;
        }
        if (this.fromIP != null) {
            s = s + ", From IP = " + this.fromIP;
        }
        if (this.toIP != null) {
            s = s + ", To IP = " + this.toIP;
        }
        if (this.dns != null) {
            s = s + ", DNS = " + this.dns;
        }
        return s;
    }

    public boolean checkValid(int productid, int thismajor, int thisminor, String thisMachInfo) throws LicenseException {
        if (productid != this.product || this.major != thismajor) {
            return false;
        }
        if (!this.machineInfo.equals(thisMachInfo)) {
            return false;
        }
        if (this.validity.getValidTill() == null) {
            return true;
        }
        GregorianCalendar dt = new GregorianCalendar();
        dt.add(5, -1);
        return dt.before(this.validity.getValidTill());
    }

    String encodeSigned(PrivateKey pk) throws LicenseException {
        try {
            byte[] byteData = this.toBytes();
            Signature dsa = Signature.getInstance("DSA");
            dsa.initSign(pk);
            dsa.update(byteData);
            byte[] sig = dsa.sign();
            byte[] signedBytes = new byte[byteData.length + sig.length + 2];
            signedBytes[0] = (byte)(byteData.length & 0xFF);
            signedBytes[1] = (byte)(byteData.length >> 8 & 0xFF);
            System.arraycopy(byteData, 0, signedBytes, 2, byteData.length);
            System.arraycopy(sig, 0, signedBytes, byteData.length + 2, sig.length);
            BASE64Encoder enc = new BASE64Encoder();
            String encoded = enc.encode(signedBytes);
            return encoded;
        }
        catch (KeyException e) {
            LicenseMessage.throwError(LicenseMessage.LICENSE_KEY_CORRUPTION);
            e.printStackTrace();
            return null;
        }
        catch (GeneralSecurityException e) {
            LicenseMessage.throwError(LicenseMessage.LICENSE_CHECK_NOT_AVAILABLE);
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            LicenseMessage.throwError(LicenseMessage.LICENSE_ENCODING_ERROR);
            return null;
        }
    }

    byte[] toBytes() throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(os);
        this.write(dos);
        byte[] bytes = os.toByteArray();
        os.close();
        SecureRandom rnd = new SecureRandom();
        byte[] encryp = new byte[4];
        ((Random)rnd).nextBytes(encryp);
        byte[] encrypted = new byte[bytes.length + 4];
        for (int i = 0; i < bytes.length; ++i) {
            encrypted[i] = (byte)(bytes[i] ^ encryp[i % 4]);
        }
        System.arraycopy(encryp, 0, encrypted, bytes.length, 4);
        return encrypted;
    }

    void fromBytes(byte[] bytes) throws IOException {
        byte[] decrypted = new byte[bytes.length - 4];
        byte[] decryp = new byte[4];
        System.arraycopy(bytes, bytes.length - 4, decryp, 0, 4);
        for (int i = 0; i < decrypted.length; ++i) {
            decrypted[i] = (byte)(bytes[i] ^ decryp[i % 4]);
        }
        ByteArrayInputStream is = new ByteArrayInputStream(decrypted);
        DataInputStream dis = new DataInputStream(is);
        this.read(dis);
    }

    String encode() throws LicenseException {
        try {
            byte[] bytes = this.toBytes();
            BASE64Encoder enc = new BASE64Encoder();
            String encoded = enc.encode(bytes);
            return encoded;
        }
        catch (Exception e) {
            LicenseMessage.throwError(LicenseMessage.LICENSE_ENCODING_ERROR);
            return null;
        }
    }

    boolean decodeSigned(String encoded, PublicKey pub) throws LicenseException {
        try {
            BASE64Decoder dec = new BASE64Decoder();
            byte[] signedBytes = dec.decodeBuffer(encoded);
            int len = signedBytes[0] & 0xFF;
            int len2 = (signedBytes[1] & 0xFF) << 8;
            len = len2 + len;
            if (len > signedBytes.length || len < 0) {
                LicenseMessage.throwError(LicenseMessage.LICENSE_ERROR);
                return false;
            }
            byte[] byteData = new byte[len];
            byte[] sig = new byte[signedBytes.length - len - 2];
            System.arraycopy(signedBytes, 2, byteData, 0, byteData.length);
            System.arraycopy(signedBytes, byteData.length + 2, sig, 0, sig.length);
            Signature dsa = null;
            try {
                dsa = Signature.getInstance("DSA");
            }
            catch (GeneralSecurityException e) {
                LicenseMessage.throwError(LicenseMessage.LICENSE_CHECK_NOT_AVAILABLE);
                return false;
            }
            dsa.initVerify(pub);
            dsa.update(byteData);
            boolean verifies = dsa.verify(sig);
            if (verifies) {
                this.fromBytes(byteData);
                return true;
            }
            LicenseMessage.throwError(LicenseMessage.LICENSE_ERROR);
        }
        catch (KeyException e) {
            LicenseMessage.throwError(LicenseMessage.LICENSE_KEY_CORRUPTION, e);
            e.printStackTrace();
            return false;
        }
        catch (GeneralSecurityException e) {
            LicenseMessage.throwError(LicenseMessage.LICENSE_ERROR, e);
            return false;
        }
        catch (Exception e) {
            LicenseMessage.throwError(LicenseMessage.LICENSE_DECODING_ERROR, e);
            return false;
        }
        return false;
    }

    boolean decode(String encoded) throws Exception {
        BASE64Decoder dec = new BASE64Decoder();
        byte[] bytes = dec.decodeBuffer(encoded);
        this.fromBytes(bytes);
        return true;
    }

    private void write(DataOutputStream dos) throws IOException {
        int flag = 0;
        if (this.startDate != null) {
            flag |= 1;
        }
        if (this.machineInfo != null) {
            flag |= 2;
        }
        if (this.validity.getRuns() != 0) {
            flag |= 8;
        }
        flag = this.validity.getValidTill() != null ? (flag |= 0x10) : (flag |= 0x20);
        if (this.productName != null) {
            flag |= 0x40;
        }
        if (this.clientId != null) {
            flag |= 0x80;
        }
        if (this.featureString != null) {
            flag |= 0x100;
        }
        if (this.licenseId != -1L) {
            flag |= 0x200;
        }
        if (this.productKey != null) {
            flag |= 0x400;
        }
        if (this.licenseType != null) {
            flag |= 0x800;
        }
        if (this.fromIP != null) {
            flag |= 0x1000;
        }
        if (this.toIP != null) {
            flag |= 0x2000;
        }
        if (this.dns != null) {
            flag |= 0x4000;
        }
        if (this.authorizationType != null) {
            flag |= 0x8000;
        }
        dos.writeInt(flag);
        dos.writeInt(this.product);
        dos.writeInt(this.licenseCount);
        byte bt = (byte)(this.minor << 5);
        bt = (byte)(bt + (0x1F & this.major));
        dos.writeByte(bt);
        if (this.startDate != null) {
            this.writeDate(dos, this.startDate);
        }
        if (this.machineInfo != null) {
            dos.writeUTF(this.machineInfo);
        }
        if (this.validity.getRuns() != 0) {
            dos.writeInt(this.validity.getRuns());
        }
        if (this.validity.getValidTill() != null) {
            this.writeDate(dos, this.validity.getValidTill());
        }
        if (this.productName != null) {
            dos.writeUTF(this.productName);
        }
        if (this.clientId != null) {
            dos.writeUTF(this.clientId);
        }
        if (this.featureString != null) {
            dos.writeUTF(this.featureString);
        }
        if (this.licenseId != -1L) {
            dos.writeLong(this.licenseId);
        }
        if (this.productKey != null) {
            dos.writeUTF(this.productKey);
        }
        if (this.licenseType != null) {
            dos.writeUTF(this.licenseType);
        }
        if (this.fromIP != null) {
            dos.writeUTF(this.fromIP);
        }
        if (this.toIP != null) {
            dos.writeUTF(this.toIP);
        }
        if (this.dns != null) {
            dos.writeUTF(this.dns);
        }
        if (this.authorizationType != null) {
            dos.writeUTF(this.authorizationType);
        }
    }

    private void read(DataInputStream dis) throws IOException {
        int flag = dis.readInt();
        this.product = dis.readInt();
        this.licenseCount = dis.readInt();
        byte bt = dis.readByte();
        this.major = bt & 0x1F;
        this.minor = bt >> 5;
        this.minor &= 7;
        if ((flag & 1) != 0) {
            this.startDate = this.readDate(dis);
        }
        if ((flag & 2) != 0) {
            this.machineInfo = dis.readUTF();
        }
        if ((flag & 8) != 0) {
            this.validity = new Validity(dis.readInt());
        }
        if ((flag & 0x10) != 0) {
            this.validity = new Validity(this.readDate(dis));
        }
        if ((flag & 0x20) != 0) {
            this.validity = new Validity();
        }
        if ((flag & 0x40) != 0) {
            this.productName = dis.readUTF();
        }
        if ((flag & 0x80) != 0) {
            this.clientId = dis.readUTF();
        }
        if ((flag & 0x100) != 0) {
            this.featureString = dis.readUTF();
        }
        if ((flag & 0x200) != 0) {
            this.licenseId = dis.readLong();
        }
        if ((flag & 0x400) != 0) {
            this.productKey = dis.readUTF();
        }
        if ((flag & 0x800) != 0 && dis.available() > 0) {
            this.licenseType = dis.readUTF();
        }
        if ((flag & 0x1000) != 0 && dis.available() > 0) {
            this.fromIP = dis.readUTF();
        }
        if ((flag & 0x2000) != 0 && dis.available() > 0) {
            this.toIP = dis.readUTF();
        }
        if ((flag & 0x4000) != 0 && dis.available() > 0) {
            this.dns = dis.readUTF();
        }
        if ((flag & 0x8000) != 0 && dis.available() > 0) {
            this.authorizationType = dis.readUTF();
        }
    }

    private String toString(Calendar dt) {
        if (dt != null) {
            String s = DateFormat.getDateInstance(1).format(dt.getTime());
            return s;
        }
        return "";
    }

    private void writeDate(DataOutputStream ds, Calendar dt) throws IOException {
        int date = 0;
        int month = 0;
        int year = 0;
        if (dt != null) {
            date = (byte)dt.get(5);
            month = (byte)dt.get(2);
            year = (short)dt.get(1);
        }
        ds.writeByte(date);
        if (date != 0) {
            ds.writeByte(month);
            ds.writeShort(year);
        }
    }

    private Calendar readDate(DataInputStream ds) throws IOException {
        byte date = ds.readByte();
        byte month = 0;
        short year = 0;
        if (date != 0) {
            month = ds.readByte();
            year = ds.readShort();
        }
        if (date == 0 && month == 0 && year == 0) {
            return null;
        }
        return new GregorianCalendar(year, month, date);
    }

    private static byte[] createMessageDigest(byte[] contents) throws Exception {
        MessageDigest sha = MessageDigest.getInstance("SHA-1");
        sha.update(contents);
        byte[] hash = sha.digest();
        return hash;
    }

    public static String featureListToDisplayString(ProtectParam prot) {
        String additionalData = prot.getFeatureString();
        StringBuffer toRet = new StringBuffer();
        if (additionalData == null) {
            additionalData = "volante.composer.*";
        }
        String[] strings = StringUtils.split(additionalData, "\n");
        for (int i = 0; i < strings.length; ++i) {
            String string = strings[i].trim();
            if (string.length() <= 0) continue;
            toRet.append(string).append("\n");
        }
        return toRet.toString();
    }

    public boolean checkRuntimeLicenseValidByIPAddress(int thismajor, int thisMinor, String fromIPAddress, String toIPAddress, String ipAddressOfCurrentRuntimeString, String findLocation) throws LicenseException, UnknownHostException {
        boolean isIPAddressMatched = false;
        boolean isLicenseDurationValid = false;
        boolean isValidLicense = false;
        if (this.major != thismajor) {
            log.warn("Volante-Runtime License Check - Major version is not matching!. Invalid Runtime License!.");
            return false;
        }
        String[] fromIPAddresses = StringUtils.split(fromIPAddress, ",");
        String[] toIPAddresses = StringUtils.split(toIPAddress, ",");
        for (int i = 0; i < fromIPAddresses.length && i < toIPAddresses.length; ++i) {
            long ipRangeFrom = ProtectParam.ipToLong(InetAddress.getByName(fromIPAddresses[i]));
            long ipRangeTo = ProtectParam.ipToLong(InetAddress.getByName(toIPAddresses[i]));
            long ipOfCurrentRuntime = ProtectParam.ipToLong(InetAddress.getByName(ipAddressOfCurrentRuntimeString));
            boolean bl = isIPAddressMatched = ipOfCurrentRuntime >= ipRangeFrom && ipOfCurrentRuntime <= ipRangeTo;
            if (!isIPAddressMatched) continue;
            isLicenseDurationValid = this.checkRuntimeLicenseValidity(findLocation);
            boolean bl2 = isValidLicense = isIPAddressMatched && isLicenseDurationValid;
            if (!isValidLicense) continue;
            return isValidLicense;
        }
        return isValidLicense;
    }

    public boolean checkRuntimeLicenseValidByHostName(int thismajor, int thisMinor, String licensedHostName, String hostNameOfCurrentSystem, String findLocation) throws LicenseException, UnknownHostException {
        String[] hosts;
        if (this.major != thismajor) {
            log.warn("Volante-Runtime License Check - Major version is not matching!. Invalid Runtime License!.");
            return false;
        }
        boolean isValidLicense = false;
        boolean isDomainNameMatched = false;
        boolean isLicenseDurationValid = false;
        for (String host : hosts = StringUtils.split(licensedHostName, ",")) {
            isDomainNameMatched = hostNameOfCurrentSystem.endsWith(host);
            if (!isDomainNameMatched) continue;
            isLicenseDurationValid = this.checkRuntimeLicenseValidity(findLocation);
            boolean bl = isValidLicense = isDomainNameMatched && isLicenseDurationValid;
            if (!isValidLicense) continue;
            return isValidLicense;
        }
        return isValidLicense;
    }

    public boolean checkRuntimeLicenseValidByMacAddress(int thismajor, int thisMinor, String runtimeMachineInfo, String findLocation) throws LicenseException, UnknownHostException {
        if (this.major != thismajor) {
            log.warn("Volante-Runtime License Check - Major version is not matching!. Invalid Runtime License!.");
            return false;
        }
        boolean isMachInfoMatched = false;
        boolean isLicenseDurationValid = false;
        boolean isValidLicense = false;
        if (this.machineInfo.contains(",")) {
            String[] multipleNodesLicensed = this.machineInfo.split(",");
            for (int i = 0; i < multipleNodesLicensed.length; ++i) {
                isMachInfoMatched = multipleNodesLicensed[i].equalsIgnoreCase(runtimeMachineInfo);
                if (!isMachInfoMatched) continue;
                isLicenseDurationValid = this.checkRuntimeLicenseValidity(findLocation);
                boolean bl = isValidLicense = isMachInfoMatched && isLicenseDurationValid;
                if (!isValidLicense) continue;
                return isValidLicense;
            }
        } else if (!this.machineInfo.equals("NA") && this.machineInfo.equalsIgnoreCase(runtimeMachineInfo) && (isValidLicense = (isLicenseDurationValid = this.checkRuntimeLicenseValidity(findLocation)))) {
            return isValidLicense;
        }
        return isValidLicense;
    }

    private boolean checkRuntimeLicenseValidity(String findLocation) {
        boolean isLicenseDurationValid = false;
        if (this.validity.getValidTill() == null) {
            isLicenseDurationValid = true;
            return isLicenseDurationValid;
        }
        GregorianCalendar dt = new GregorianCalendar();
        dt.add(5, -1);
        if (dt.before(this.validity.getValidTill())) {
            isLicenseDurationValid = true;
            return isLicenseDurationValid;
        }
        ProtectParam.printValidLicenseInfoExpired();
        return isLicenseDurationValid;
    }

    public boolean allowInvalidAndExpiredLicensesOnlyForProductionAuthorizations() {
        return this.authorizationType.equalsIgnoreCase(LicenseType.Production.name()) && (this.licenseType.equalsIgnoreCase(RuntimeLicenseType.Production.name()) || this.licenseType.equalsIgnoreCase(RuntimeLicenseType.DR.value));
    }

    private static void printValidLicenseInfoExpired() {
        ProtectParam.printLicenseInfoFirstAndLastLine();
        log.warn("* RUNTIME LICENSE HAS EXPIRED - CONTACT VOLANTE FOR RENEWAL *");
        ProtectParam.printLicenseInfoFirstAndLastLine();
    }

    private static void printLicenseInfoFirstAndLastLine() {
        log.warn("**********************************************************************");
    }

    boolean decodeSignedRuntime(String encoded, PublicKey pub) throws LicenseException {
        try {
            BASE64Decoder dec = new BASE64Decoder();
            byte[] signedBytes = dec.decodeBuffer(encoded);
            int len = signedBytes[0] & 0xFF;
            int len2 = (signedBytes[1] & 0xFF) << 8;
            len = len2 + len;
            if (len > signedBytes.length || len < 0) {
                LicenseMessage.throwError(LicenseMessage.LICENSE_ERROR);
                return false;
            }
            byte[] byteData = new byte[len];
            byte[] sig = new byte[signedBytes.length - len - 2];
            System.arraycopy(signedBytes, 2, byteData, 0, byteData.length);
            System.arraycopy(signedBytes, byteData.length + 2, sig, 0, sig.length);
            Signature dsa = null;
            try {
                dsa = Signature.getInstance("DSA");
            }
            catch (GeneralSecurityException e) {
                LicenseMessage.throwError(LicenseMessage.LICENSE_CHECK_NOT_AVAILABLE);
                return false;
            }
            dsa.initVerify(pub);
            dsa.update(byteData);
            boolean verifies = dsa.verify(sig);
            if (verifies) {
                this.fromBytes(byteData);
                return true;
            }
            LicenseMessage.throwError(LicenseMessage.LICENSE_ERROR);
        }
        catch (KeyException e) {
            LicenseMessage.throwError(LicenseMessage.LICENSE_KEY_CORRUPTION, e);
            e.printStackTrace();
            return false;
        }
        catch (GeneralSecurityException e) {
            LicenseMessage.throwError(LicenseMessage.LICENSE_ERROR, e);
            return false;
        }
        catch (Exception e) {
            LicenseMessage.throwError(LicenseMessage.LICENSE_DECODING_ERROR, e);
            return false;
        }
        return false;
    }

    public static long ipToLong(InetAddress ip) {
        byte[] octets = ip.getAddress();
        long result = 0L;
        for (int i = 0; i < octets.length; ++i) {
            result <<= 8;
            byte octet = octets[i];
            result |= (long)(octet & 0xFF);
        }
        return result;
    }
}

