/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.license;

import com.tplus.license.LicenseEncoder;
import com.tplus.license.NetworkMachInfo;
import com.tplus.license.ParserInfo;
import com.tplus.license.ProtectParam;
import com.tplus.license.Validity;
import com.tplus.license.lg.manager.GlobalResource;
import com.tplus.license.lg.wsclient.LicenseType;
import com.tplus.license.lg.wsclient.RuntimeLicenseType;
import com.tplus.transform.util.IOUtil;
import com.tplus.transform.util.VersionConstants;
import com.tplus.transform.util.log.Log;
import com.tplus.transform.util.log.LogFactory;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.List;

public class RuntimeLicenseVerifierSingleton {
    private static boolean isRuntimeLicenseJarAvailable;
    protected static final Log log;
    public static int PRODUCT_ID;
    public static int MAJOR_VERSION;
    public static int MINOR_VERSION;
    public static final String RUNTIME_MANIFEST = "MANIFEST.MF";
    public static final String MACH_ID = "MACH_ID";
    public static final String IP_ADDRESS = "IP_ADDRESS";
    public static final String HOST_NAME = "HOST_NAME";
    private static final String DEFAULT_ENCODING = "UTF-8";
    private static final boolean skipLicCheck = false;
    private static final boolean skipLicViolation = false;
    private static RuntimeLicenseVerifierSingleton instance;
    private static boolean runtimeLicenseFileFound;
    static String authorizationType;
    static String licenseType;
    static String productKey;
    static String clientId;
    static Validity validity;

    private RuntimeLicenseVerifierSingleton() {
        try {
            isRuntimeLicenseJarAvailable = RuntimeLicenseVerifierSingleton.readAndCheckRuntimePermFromClassPath();
            if (!isRuntimeLicenseJarAvailable) {
                isRuntimeLicenseJarAvailable = RuntimeLicenseVerifierSingleton.readAndCheckLicenseJarFromClassPathSimple();
            }
            if (!isRuntimeLicenseJarAvailable) {
                isRuntimeLicenseJarAvailable = RuntimeLicenseVerifierSingleton.validateDesignerPermAndRuntimeJarFromVolanteHome();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error(e.getMessage());
        }
        finally {
            String volanteHome = System.getenv("VOLANTE_RUNTIME_HOME");
            if (!runtimeLicenseFileFound) {
                log.warn("**********************************************************************");
                if (volanteHome != null) {
                    log.debug("* VOLANTE_RUNTIME_HOME :: " + volanteHome + " *");
                }
                if (!isRuntimeLicenseJarAvailable) {
                    log.warn("* VOLANTE RUNTIME LICENSE NOT FOUND *");
                }
                log.warn("**********************************************************************");
                isRuntimeLicenseJarAvailable = true;
            }
        }
    }

    public static synchronized RuntimeLicenseVerifierSingleton getInstance() {
        if (instance == null) {
            instance = new RuntimeLicenseVerifierSingleton();
        }
        return instance;
    }

    public static boolean isRuntimeLicenseValid() {
        return isRuntimeLicenseJarAvailable;
    }

    private static boolean checkRuntimeLicenseByMacAddressOrIPAddressOrHostName(ProtectParam[] protectParams, String logText) throws Exception {
        boolean isValidLicense = false;
        boolean isValidLicenseAfterProductionCheck = false;
        for (int i = 0; i < protectParams.length; ++i) {
            boolean productionCheck;
            String licensedMachId = protectParams[i].getMachineInfo();
            String licensedIpAddressRangeFrom = protectParams[i].getFromIP();
            String licensedIPAddressRangeTo = protectParams[i].getToIP();
            String licensedHostName = protectParams[i].getDns();
            authorizationType = protectParams[i].getAuthorizationType();
            licenseType = protectParams[i].getLicenseType();
            productKey = protectParams[i].getProductKey();
            clientId = protectParams[i].getClientId();
            validity = protectParams[i].getValidity();
            log.warn("Started to check the runtime license jar/perm file of " + (i + 1));
            if (licensedMachId != null && !licensedMachId.equals("NA")) {
                List macInfoOfRuntimeEnv = NetworkMachInfo.getAllMacAddresses();
                for (Object aMacInfoOfRuntimeEnv : macInfoOfRuntimeEnv) {
                    String macAddress = (String)aMacInfoOfRuntimeEnv;
                    isValidLicense = protectParams[i].checkRuntimeLicenseValidByMacAddress(MAJOR_VERSION, MINOR_VERSION, macAddress, logText);
                    if (!isValidLicense) continue;
                    RuntimeLicenseVerifierSingleton.printValidLicenseInfo(isValidLicense, logText);
                    return isValidLicense;
                }
                productionCheck = RuntimeLicenseVerifierSingleton.allowInvalidAndExpiredLicensesOnlyForProductionAuthorizations();
                RuntimeLicenseVerifierSingleton.printValidLicenseInfo(false, logText);
                if (!isValidLicenseAfterProductionCheck) {
                    isValidLicenseAfterProductionCheck = productionCheck;
                }
            }
            if (licensedIpAddressRangeFrom != null && licensedIPAddressRangeTo != null) {
                List ipAddressesOfRuntimeEnv = NetworkMachInfo.getAllIPAddresses();
                for (Object anIpAddressesOfRuntimeEnv : ipAddressesOfRuntimeEnv) {
                    String ipAddressOfCurrentRuntime = (String)anIpAddressesOfRuntimeEnv;
                    isValidLicense = protectParams[i].checkRuntimeLicenseValidByIPAddress(MAJOR_VERSION, MINOR_VERSION, licensedIpAddressRangeFrom, licensedIPAddressRangeTo, ipAddressOfCurrentRuntime, logText);
                    if (!isValidLicense) continue;
                    RuntimeLicenseVerifierSingleton.printValidLicenseInfo(isValidLicense, logText);
                    return isValidLicense;
                }
                productionCheck = RuntimeLicenseVerifierSingleton.allowInvalidAndExpiredLicensesOnlyForProductionAuthorizations();
                RuntimeLicenseVerifierSingleton.printValidLicenseInfo(false, logText);
                if (!isValidLicenseAfterProductionCheck) {
                    isValidLicenseAfterProductionCheck = productionCheck;
                }
            }
            if (licensedHostName == null) continue;
            List hostNamesOfRuntimeEnv = NetworkMachInfo.getAllHostNames();
            for (Object aHostNamesOfRuntimeEnv : hostNamesOfRuntimeEnv) {
                String hostNameOfCurrentRuntime = (String)aHostNamesOfRuntimeEnv;
                isValidLicense = protectParams[i].checkRuntimeLicenseValidByHostName(MAJOR_VERSION, MINOR_VERSION, licensedHostName, hostNameOfCurrentRuntime, logText);
                if (!isValidLicense) continue;
                RuntimeLicenseVerifierSingleton.printValidLicenseInfo(isValidLicense, logText);
                return isValidLicense;
            }
            productionCheck = RuntimeLicenseVerifierSingleton.allowInvalidAndExpiredLicensesOnlyForProductionAuthorizations();
            RuntimeLicenseVerifierSingleton.printValidLicenseInfo(false, logText);
            if (isValidLicenseAfterProductionCheck) continue;
            isValidLicenseAfterProductionCheck = productionCheck;
        }
        return isValidLicenseAfterProductionCheck || isValidLicense;
    }

    public static boolean allowInvalidAndExpiredLicensesOnlyForProductionAuthorizations() {
        return authorizationType.equalsIgnoreCase(LicenseType.Production.name()) && (licenseType.equalsIgnoreCase(RuntimeLicenseType.Production.name()) || licenseType.equalsIgnoreCase(RuntimeLicenseType.DR.value) || licenseType.equalsIgnoreCase("IP") || licenseType.equalsIgnoreCase("DNS"));
    }

    private static boolean readAndCheckRuntimePermFromClassPath() throws Exception {
        InputStream runtimePermIS;
        boolean isValidLicense = false;
        URL runtimePermFileURL = RuntimeLicenseVerifierSingleton.class.getResource(System.getProperty("file.separator") + "runtime.perm");
        if (runtimePermFileURL != null && (runtimePermIS = runtimePermFileURL.openStream()) != null) {
            String runtimePermFilePath = runtimePermFileURL.getPath();
            runtimePermFilePath = runtimePermFilePath.substring(1);
            runtimeLicenseFileFound = true;
            ProtectParam[] runtimeProtectParam = RuntimeLicenseVerifierSingleton.readPermFileData(runtimePermIS);
            isValidLicense = RuntimeLicenseVerifierSingleton.checkRuntimeLicenseByMacAddressOrIPAddressOrHostName(runtimeProtectParam, runtimePermFilePath + " in application classpath.");
        }
        return isValidLicense;
    }

    private static boolean readAndCheckLicenseJarFromClassPathSimple() throws Exception {
        InputStream runtimePermFileInputStream;
        boolean isValidLicense = false;
        URL runtimePermFileURL = RuntimeLicenseVerifierSingleton.class.getClassLoader().getResource("runtime.perm");
        if (runtimePermFileURL != null && (runtimePermFileInputStream = runtimePermFileURL.openStream()) != null) {
            String runtimePermFilePath = runtimePermFileURL.getPath();
            int firstIndexOfFileSeparator = runtimePermFilePath.indexOf("/");
            int lastIndexOfFileSeparator = runtimePermFilePath.lastIndexOf("!/");
            runtimePermFilePath = lastIndexOfFileSeparator != -1 ? runtimePermFilePath.substring(firstIndexOfFileSeparator + 1, lastIndexOfFileSeparator) : runtimePermFilePath.substring(firstIndexOfFileSeparator + 1);
            runtimeLicenseFileFound = true;
            ProtectParam[] protectParam = RuntimeLicenseVerifierSingleton.readPermFileData(runtimePermFileInputStream);
            isValidLicense = RuntimeLicenseVerifierSingleton.checkRuntimeLicenseByMacAddressOrIPAddressOrHostName(protectParam, runtimePermFilePath + " in application classpath.");
        }
        return isValidLicense;
    }

    public static ProtectParam[] readPermFileData(InputStream is) throws Exception {
        byte[] bFile = IOUtil.readStream(is);
        String allEncodedRuntimeDetails = new String(bFile, DEFAULT_ENCODING);
        LicenseEncoder encoder = new LicenseEncoder("tplus_runtime.pub", "", new GlobalResource());
        ProtectParam[] protectParams = encoder.readRuntimeLicenseString(allEncodedRuntimeDetails);
        return protectParams;
    }

    public static ProtectParam readDesignerPermFileData(InputStream is) throws Exception {
        byte[] bFile = IOUtil.readStream(is);
        String allEncodedRuntimeDetails = new String(bFile, DEFAULT_ENCODING);
        LicenseEncoder encoder = new LicenseEncoder("tplus.pub", "designer.pri", new GlobalResource());
        ProtectParam protectParam = encoder.readLicenseString(allEncodedRuntimeDetails);
        return protectParam;
    }

    static synchronized boolean validateDesignerPermAndRuntimeJarFromVolanteHome() throws Exception {
        boolean isValidLicense = false;
        String volanteHome = System.getenv("VOLANTE_RUNTIME_HOME");
        if (volanteHome != null) {
            try {
                URL licenseJarURL = null;
                File volanteHomeDir = new File(volanteHome);
                File[] listOfRuntimeJars = RuntimeLicenseVerifierSingleton.findFilesOfVolanteLicense(volanteHomeDir);
                if (listOfRuntimeJars != null) {
                    int fileCount = listOfRuntimeJars.length;
                    for (File listOfRuntimeJar : listOfRuntimeJars) {
                        runtimeLicenseFileFound = true;
                        String licenseJarPath = listOfRuntimeJar.toURI().toURL().getPath();
                        licenseJarURL = new URL("jar:file:" + licenseJarPath + "!/runtime.perm");
                        InputStream runtimePermFileInputStream = licenseJarURL.openStream();
                        ProtectParam[] protectParam = RuntimeLicenseVerifierSingleton.readPermFileData(runtimePermFileInputStream);
                        isValidLicense = RuntimeLicenseVerifierSingleton.checkRuntimeLicenseByMacAddressOrIPAddressOrHostName(protectParam, listOfRuntimeJar.getName() + " in " + volanteHome + " folder.");
                        if (!isValidLicense) continue;
                        return isValidLicense;
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (!isValidLicense) {
                isValidLicense = RuntimeLicenseVerifierSingleton.validateRuntimePermFileInVolanteHome(volanteHome);
            }
            if (!isValidLicense) {
                isValidLicense = RuntimeLicenseVerifierSingleton.validateDesignerPermFileInVolanteRuntimeHome(volanteHome);
            }
        }
        return isValidLicense;
    }

    private static boolean validateRuntimePermFileInVolanteHome(String volanteHome) throws Exception {
        boolean isValidLicense = false;
        File runtimePermFile = new File(volanteHome + System.getProperty("file.separator") + "runtime.perm");
        if (runtimePermFile != null && runtimePermFile.exists()) {
            runtimeLicenseFileFound = true;
            FileInputStream runtimePermIS = new FileInputStream(runtimePermFile);
            ProtectParam[] runtimeProtectParam = RuntimeLicenseVerifierSingleton.readPermFileData(runtimePermIS);
            isValidLicense = RuntimeLicenseVerifierSingleton.checkRuntimeLicenseByMacAddressOrIPAddressOrHostName(runtimeProtectParam, runtimePermFile.getName() + " in " + volanteHome + " folder.");
        }
        return isValidLicense;
    }

    private static boolean validateDesignerPermFileInVolanteRuntimeHome(String volanteHome) throws Exception {
        boolean isValidLicense = false;
        File designerPermFile = new File(volanteHome + System.getProperty("file.separator") + "designer.perm");
        if (designerPermFile != null && designerPermFile.exists()) {
            try {
                runtimeLicenseFileFound = true;
                FileInputStream fis = new FileInputStream(designerPermFile);
                ProtectParam designerProtectParam = RuntimeLicenseVerifierSingleton.readDesignerPermFileData(fis);
                authorizationType = null;
                licenseType = null;
                productKey = null;
                clientId = null;
                validity = null;
                List macInfoOfRuntimeEnv = NetworkMachInfo.getAllMacAddresses();
                System.setProperty("designer.home", volanteHome);
                ParserInfo parserInfo = new ParserInfo(designerProtectParam.getMachineInfo());
                isValidLicense = designerProtectParam.checkValid(PRODUCT_ID, MAJOR_VERSION, 0, parserInfo.getMach());
                if (isValidLicense) {
                    RuntimeLicenseVerifierSingleton.printValidLicenseInfo(true, designerPermFile.getName() + " in " + volanteHome + " folder.");
                    return isValidLicense;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return isValidLicense;
    }

    private static void printValidLicenseInfo(boolean validOrInvalid, String findLocation) {
        RuntimeLicenseVerifierSingleton.printLicenseInfoFirstAndLastLine();
        RuntimeLicenseVerifierSingleton.printLicenseInfoDetails(validOrInvalid, findLocation);
        RuntimeLicenseVerifierSingleton.printLicenseInfoFirstAndLastLine();
    }

    private static void printLicenseInfoDetails(boolean validOrInvalid, String findLocation) {
        String strValidOrInvalid = "";
        strValidOrInvalid = validOrInvalid ? "VALID" : "INVALID";
        log.warn("* " + strValidOrInvalid + " VOLANTE RUNTIME LICENSE FOUND *");
        if (findLocation != null) {
            log.debug("* RUNTIME LICENSE FILE        :: " + findLocation + " *");
        }
        if (productKey != null) {
            log.warn("* PRODUCT KEY                 :: " + productKey + " *");
        }
        if (clientId != null) {
            log.warn("* LICENSED TO                 :: " + clientId + " *");
        }
        if (validity != null) {
            log.warn("* VALIDITY                    :: " + validity + " *");
        }
        if (licenseType == null) {
            licenseType = "Designer";
        }
        if (authorizationType != null) {
            log.warn("* AUTHORIZATION TYPE          :: " + authorizationType + " *");
        } else {
            log.warn("* AUTHORIZATION TYPE          :: Designer License *");
        }
        log.warn("* RUNTIME LICENSE TYPE        :: " + licenseType + " *");
    }

    private static void printLicenseInfoFirstAndLastLine() {
        log.warn("**********************************************************************");
    }

    private static File[] findFilesOfVolanteLicense(File dir) {
        return dir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.getName().matches("(.*)volante-runtime-license(.*).jar");
            }
        });
    }

    static {
        log = LogFactory.getLog("RuntimeLicenseVerifierSingleton");
        PRODUCT_ID = VersionConstants.PRODUCT_ID;
        MAJOR_VERSION = VersionConstants.MAJOR_VERSION;
        MINOR_VERSION = VersionConstants.MINOR_VERSION;
        instance = new RuntimeLicenseVerifierSingleton();
        runtimeLicenseFileFound = false;
        authorizationType = null;
        licenseType = null;
        productKey = null;
        clientId = null;
        validity = null;
    }
}

