/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.io;

import com.tplus.transform.io.RandomAccessStream;
import java.io.IOException;
import java.io.InputStream;

public abstract class AbstractRandomAccessStream
implements RandomAccessStream {
    private static final int SKIP_BUFFER_SIZE = 2048;
    private static byte[] skipBuffer;

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int i;
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        int c = this.read();
        if (c == -1) {
            return -1;
        }
        b[off] = (byte)c;
        try {
            for (i = 1; i < len && (c = this.read()) != -1; ++i) {
                if (b == null) continue;
                b[off + i] = (byte)c;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return i;
    }

    @Override
    public long skip(long n) throws IOException {
        int nr;
        long remaining = n;
        if (skipBuffer == null) {
            skipBuffer = new byte[2048];
        }
        byte[] localSkipBuffer = skipBuffer;
        if (n <= 0L) {
            return 0L;
        }
        while (remaining > 0L && (nr = this.read(localSkipBuffer, 0, (int)Math.min(2048L, remaining))) >= 0) {
            remaining -= (long)nr;
        }
        return n - remaining;
    }

    @Override
    public void close() throws IOException {
    }

    public InputStream getInputStream() {
        return new InputStream(){
            int position;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int read(byte[] b, int off, int len) throws IOException {
                long oldPos = AbstractRandomAccessStream.this.getPosition();
                try {
                    AbstractRandomAccessStream.this.seek(this.position);
                    int n = AbstractRandomAccessStream.this.read(b, off, len);
                    return n;
                }
                finally {
                    AbstractRandomAccessStream.this.seek(oldPos);
                }
            }

            @Override
            public int read(byte[] b) throws IOException {
                return AbstractRandomAccessStream.this.read(b);
            }

            @Override
            public long skip(long n) throws IOException {
                return AbstractRandomAccessStream.this.skip(n);
            }

            @Override
            public int read() throws IOException {
                return AbstractRandomAccessStream.this.read();
            }
        };
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        for (int i = 0; i < len; ++i) {
            this.write(b[off + i]);
        }
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public boolean canSeekBackwards() {
        return true;
    }
}

