/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.io;

import com.tplus.transform.io.FilenameUtils;
import java.io.File;
import java.io.FilenameFilter;
import java.util.List;

public class WildcardFilter
implements FilenameFilter {
    private String[] wildcards = null;

    public WildcardFilter(String wildcard) {
        if (wildcard == null) {
            throw new IllegalArgumentException();
        }
        this.wildcards = new String[]{wildcard};
    }

    public WildcardFilter(String[] wildcards) {
        if (wildcards == null) {
            throw new IllegalArgumentException();
        }
        this.wildcards = wildcards;
    }

    public WildcardFilter(List wildcards) {
        if (wildcards == null) {
            throw new IllegalArgumentException();
        }
        this.wildcards = wildcards.toArray(new String[wildcards.size()]);
    }

    @Override
    public boolean accept(File dir, String name) {
        if (dir != null && new File(dir, name).isDirectory()) {
            return false;
        }
        for (String wildcard : this.wildcards) {
            if (!FilenameUtils.wildcardMatch(name, wildcard)) continue;
            return true;
        }
        return false;
    }

    public boolean accept(File file) {
        if (file.isDirectory()) {
            return false;
        }
        for (String wildcard : this.wildcards) {
            if (!FilenameUtils.wildcardMatch(file.getName(), wildcard)) continue;
            return true;
        }
        return false;
    }

    public static void main(String[] args) {
        String[] names;
        File dir = new File(".");
        WildcardFilter fileFilter = new WildcardFilter("*test*.java~*~");
        for (String name : names = dir.list(fileFilter)) {
            System.out.println(new File(dir, name));
        }
    }
}

