/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.io.fs;

import com.tplus.transform.io.fs.FilePath;
import com.tplus.transform.io.fs.FileSystem;
import com.tplus.transform.util.IOUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.swing.filechooser.FileSystemView;

public class LocalFileSystem
extends FileSystem {
    public static FileSystemView systemView = FileSystemView.getFileSystemView();

    @Override
    public FilePath createPath(String name) {
        return new LocalFile(name);
    }

    @Override
    public FilePath createPath(FilePath parent, String name) {
        return new LocalFile((LocalFile)parent, name);
    }

    @Override
    public FilePath[] getFiles(FilePath f, boolean b) {
        LocalFile localFile = (LocalFile)f;
        File[] files = systemView.getFiles(localFile.file, b);
        return this.toPaths(files);
    }

    private FilePath[] toPaths(File[] files) {
        FilePath[] toRet = new FilePath[files.length];
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            toRet[i] = new LocalFile(file);
        }
        return toRet;
    }

    @Override
    public String getSystemDisplayName(FilePath filePath) {
        LocalFile localFile = (LocalFile)filePath;
        return systemView.getSystemDisplayName(localFile.file);
    }

    @Override
    public FilePath[] listRoots() {
        File[] files = File.listRoots();
        return this.toPaths(files);
    }

    @Override
    public FilePath getHomeDirectory() {
        return new LocalFile(System.getProperty("user.dir"));
    }

    class LocalFile
    extends FilePath {
        File file;

        LocalFile(String path) {
            this.file = new File(path);
        }

        LocalFile(LocalFile parent, String child) {
            this.file = new File(parent.file, child);
        }

        public LocalFile(File file) {
            this.file = file;
        }

        @Override
        public String getPath() {
            return this.file.getPath();
        }

        @Override
        public String getName() {
            return this.file.getName();
        }

        @Override
        public String getAbsolutePath() {
            return this.file.getAbsolutePath();
        }

        @Override
        public FilePath getParentFile() {
            File parentFile = this.file.getParentFile();
            if (parentFile != null) {
                return new LocalFile(parentFile);
            }
            return null;
        }

        @Override
        public FilePath getCanonicalFile() throws IOException {
            return new LocalFile(this.file.getCanonicalFile());
        }

        @Override
        public boolean exists() {
            return this.file.exists();
        }

        @Override
        public boolean isDirectory() {
            return this.file.isDirectory();
        }

        @Override
        public boolean isFile() {
            return this.file.isFile();
        }

        @Override
        public int compareTo(FilePath filePath) {
            LocalFile l1 = this;
            LocalFile l2 = (LocalFile)filePath;
            return l1.file.compareTo(l2.file);
        }

        @Override
        public FilePath[] listFiles() throws IOException {
            return LocalFileSystem.this.getFiles(this, false);
        }

        @Override
        public String toString() {
            return this.file.toString();
        }

        @Override
        public boolean equals(Object other) {
            return this.file.equals(((LocalFile)other).file);
        }

        public int hashCode() {
            return this.file.hashCode();
        }

        @Override
        public void delete() {
            if (this.file.isDirectory()) {
                IOUtil.delDir(this.file);
            } else {
                this.file.delete();
            }
        }

        @Override
        public boolean isLocal() {
            return true;
        }

        @Override
        public void copyTo(File localFile) {
            IOUtil.copyFile(this.file.getAbsolutePath(), localFile.getAbsolutePath());
        }

        @Override
        public void copyFrom(File localFile) throws IOException {
            IOUtil.copyFile(localFile.getAbsolutePath(), this.file.getAbsolutePath());
        }

        @Override
        public void copyLocalAsChild(File tempFile) {
            File subFile = new File(this.file, tempFile.getName());
            if (tempFile.isDirectory()) {
                subFile.mkdir();
            } else {
                IOUtil.copyFile(tempFile.getAbsolutePath(), subFile.getAbsolutePath());
            }
        }

        @Override
        public FilePath mkDir(String name) {
            File subfile = new File(this.file, name);
            subfile.mkdir();
            return new LocalFile(subfile);
        }

        @Override
        public boolean mkDir() throws IOException {
            return this.file.mkdir();
        }

        @Override
        public OutputStream createOutputStream() throws IOException {
            return new FileOutputStream(this.file);
        }

        @Override
        public InputStream createInputStream() throws IOException {
            return new FileInputStream(this.file);
        }

        @Override
        public Map getProperties() throws IOException {
            HashMap<String, Object> toRet = new HashMap<String, Object>();
            toRet.put("Last Modified", new Date(this.file.lastModified()));
            toRet.put("Size", Long.toString(this.file.length()));
            toRet.put("Location", this.file.getParent());
            return toRet;
        }

        @Override
        public FilePath createChild(String name) {
            return new LocalFile(this, name);
        }

        @Override
        public boolean createNewFile() throws IOException {
            return this.file.createNewFile();
        }

        @Override
        public void renameTo(String newValue) throws IOException {
            File newFile = new File(this.file.getParent(), newValue);
            if (!this.file.renameTo(newFile)) {
                throw new IOException("Unable to rename " + this.file.getName() + " to " + newFile.getName());
            }
            this.file = newFile;
        }
    }
}

