/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.lang;

import com.tplus.transform.lang.CallListener;
import com.tplus.transform.lang.ClassResolver;
import com.tplus.transform.lang.ClassUtil;
import com.tplus.transform.lang.GenericObjectFactory;
import com.tplus.transform.lang.GenericObjectPool;
import com.tplus.transform.lang.NoOpCallListener;
import com.tplus.transform.lang.ObjectFactory;
import com.tplus.transform.lang.ObjectPool;
import com.tplus.transform.lang.PoolingProxy;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;

public abstract class AbstractPoolingProxy
implements PoolingProxy {
    private ObjectPool objectPool;
    protected Class interfaceClass;
    protected Object cachedProxy;
    CallListener callListener = NoOpCallListener.INSTANCE;
    private Object callbackReference;
    ClassResolver classResolver;

    public AbstractPoolingProxy(Class actualClass, Class interfaceClass) {
        this(new GenericObjectFactory(actualClass), interfaceClass);
    }

    public AbstractPoolingProxy(ObjectFactory objectFactory, Class interfaceClass) {
        this(AbstractPoolingProxy.createPool(objectFactory), interfaceClass);
    }

    public AbstractPoolingProxy(ObjectPool objectPool, Class interfaceClass) {
        this.objectPool = objectPool;
        this.interfaceClass = interfaceClass;
    }

    @Override
    public void reset() {
        this.objectPool = null;
        this.cachedProxy = null;
    }

    public void reset(Class actualClass, Class interfaceClass) {
        this.objectPool = AbstractPoolingProxy.createPool(new GenericObjectFactory(actualClass));
        this.interfaceClass = interfaceClass;
        this.cachedProxy = null;
    }

    public void setClassResolver(ClassResolver classResolver) {
        this.classResolver = classResolver;
    }

    private static ObjectPool createPool(ObjectFactory objectFactory) {
        try {
            Class<?> aClass = Class.forName("com.tplus.transform.lang.pool.ObjectPoolImpl");
            Constructor<?> constructor = aClass.getConstructor(ObjectFactory.class);
            ObjectPool objectPool = (ObjectPool)constructor.newInstance(objectFactory);
            return objectPool;
        }
        catch (Error | Exception e) {
            return new GenericObjectPool(objectFactory);
        }
    }

    @Override
    public synchronized Object getProxy() throws IllegalAccessException, InstantiationException {
        this.resolve();
        if (this.cachedProxy == null) {
            this.objectPool.ensureCapacity(1);
            this.cachedProxy = this.createProxy();
        }
        return this.cachedProxy;
    }

    protected abstract Object createProxy() throws IllegalAccessException, InstantiationException;

    @Override
    public synchronized Object getObject() throws IllegalAccessException, InstantiationException {
        this.resolve();
        Object o = this.objectPool.createObjectNoPool();
        return o;
    }

    @Override
    public int getObjectCount() {
        return this.objectPool.getObjectCount();
    }

    @Override
    public void addCallListener(CallListener callListener, Object callbackReference) {
        this.callListener = callListener;
        this.callbackReference = callbackReference;
    }

    @Override
    public void removeCallListener(CallListener callListener) {
        this.callListener = NoOpCallListener.INSTANCE;
    }

    public final Object getObjectFromPoolForCall(Method method) throws IllegalAccessException, InstantiationException {
        this.resolve();
        Object obj = this.objectPool.getObjectFromPool();
        this.onCallStart(obj, method);
        return obj;
    }

    void resolve() throws IllegalStateException {
        if (this.objectPool == null && this.classResolver != null) {
            this.classResolver.resolve(this);
        }
        if (this.objectPool == null) {
            String message = "Object no longer valid";
            if (this.interfaceClass != null) {
                message = message + " - " + ClassUtil.getSimpleName(this.interfaceClass);
            }
            throw new IllegalStateException(message);
        }
    }

    private void onCallStart(Object obj, Method method) {
        this.callListener.onCallStart(this.callbackReference, obj, method);
    }

    private void onCallEnd(Object obj, Method method) {
        this.callListener.onCallEnd(this.callbackReference, obj, method);
    }

    public final void releaseObjectToPool(Object obj, Method method) {
        this.onCallEnd(obj, method);
        if (this.objectPool != null) {
            this.objectPool.releaseObjectToPool(obj);
        }
    }
}

