/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.lang;

import com.tplus.transform.lang.FastStringBuffer;
import com.tplus.transform.lang.IInputStream;
import com.tplus.transform.lang.Wrapper;
import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;

public class ByteBuffer
implements Serializable,
IInputStream {
    public static final char DOT_DECIMAL_POINT = '.';
    public static final char COMMA_DECIMAL_POINT = ',';
    static byte[] ZERO_BYTES = new byte[0];
    byte[] buf;
    int count;
    String encoding;
    int readCursor;

    public ByteBuffer(String encoding) {
        this(16, encoding);
    }

    public ByteBuffer(int capacity, String encoding) {
        this.buf = new byte[capacity];
        this.encoding = encoding;
    }

    public ByteBuffer(byte[] bytes, int count) {
        this.buf = bytes;
        this.count = count;
    }

    public ByteBuffer(byte[] bytes, int startIndex, int count) {
        this.buf = bytes;
        this.count = count;
        this.readCursor = startIndex;
    }

    public ByteBuffer(byte[] bytes) {
        this(bytes, bytes.length);
    }

    @Override
    public int read() throws IOException {
        if (this.readCursor >= this.count) {
            this.throwOverflow();
        }
        int toRet = this.buf[this.readCursor++] & 0xFF;
        return toRet;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int length = this.count - this.readCursor;
        length = Math.min(length, len);
        System.arraycopy(this.buf, this.readCursor, b, off, length);
        return length;
    }

    public byte readByte() throws IOException {
        if (this.readCursor >= this.count) {
            this.throwOverflow();
        }
        return this.buf[this.readCursor++];
    }

    public boolean hasMore() {
        return this.readCursor < this.count;
    }

    private void throwOverflow() throws IOException {
        throw new IOException("Out of bounds, attempt to read at " + this.readCursor + ", size  is " + this.count);
    }

    void ensureFree(int length) {
        this.expandCapacity(this.count + length);
    }

    void expandCapacity(int newcount) {
        if (newcount > this.buf.length) {
            byte[] newbuf = new byte[Math.max(this.buf.length << 1, newcount)];
            System.arraycopy(this.buf, 0, newbuf, 0, this.count);
            this.buf = newbuf;
        }
    }

    public int length() {
        return this.count;
    }

    public void write(int byteVal) {
        this.ensureFree(1);
        this.buf[this.count++] = (byte)byteVal;
    }

    public void append(char c) {
        this.ensureFree(1);
        this.buf[this.count++] = (byte)c;
    }

    public void append(int i) {
        this.appendASCII(Wrapper.toString(i));
    }

    public void append(long l) {
        this.appendASCII(String.valueOf(l));
    }

    public void append(float f, char decimalPoint) {
        String valueStr = String.valueOf(f);
        if (decimalPoint != '.') {
            valueStr = valueStr.replace('.', decimalPoint);
        }
        this.appendASCII(valueStr);
    }

    public void append(float f) {
        this.appendASCII(String.valueOf(f));
    }

    public void append(double d, char decimalPoint) {
        String valueStr = String.valueOf(d);
        if (decimalPoint != '.') {
            valueStr = valueStr.replace('.', decimalPoint);
        }
        this.appendASCII(valueStr);
    }

    public void append(double d) {
        this.appendASCII(String.valueOf(d));
    }

    public void append(String str) throws UnsupportedEncodingException {
        this.append0(str);
    }

    public void append(ByteBuffer toAdd) {
        int len = toAdd.length();
        this.ensureFree(len);
        System.arraycopy(toAdd.buf, 0, this.buf, this.count, len);
        this.count += len;
    }

    public void append(byte[] toAdd) {
        int len = toAdd.length;
        this.ensureFree(len);
        System.arraycopy(toAdd, 0, this.buf, this.count, len);
        this.count += len;
    }

    public void append(byte[] toAdd, int startOffset, int bytesCount) {
        this.ensureFree(bytesCount);
        System.arraycopy(toAdd, startOffset, this.buf, this.count, bytesCount);
        this.count += bytesCount;
    }

    public void append(FastStringBuffer str) throws UnsupportedEncodingException {
        if (str == null) {
            return;
        }
        this.append(str.toString());
    }

    public void append(StringBuffer str) throws UnsupportedEncodingException {
        if (str == null) {
            return;
        }
        this.append(str.toString());
    }

    public void append(char[] str) throws UnsupportedEncodingException {
        if (str == null) {
            return;
        }
        this.append(this.toBytes(str));
    }

    private void appendASCII(String str) {
        if (str == null) {
            return;
        }
        int len = str.length();
        this.ensureFree(len);
        str.getBytes(0, len, this.buf, this.count);
        this.count += len;
    }

    private void append0(String str) throws UnsupportedEncodingException {
        if (str == null) {
            return;
        }
        int len = str.length();
        byte[] bytes = this.toBytes(str);
        this.append(bytes);
    }

    private byte[] toBytes(char[] str) throws UnsupportedEncodingException {
        return this.toBytes(new String(str));
    }

    private byte[] toBytes(String str) throws UnsupportedEncodingException {
        byte[] bytes = this.encoding != null ? str.getBytes(this.encoding) : str.getBytes();
        return bytes;
    }

    public void chop(int marker) {
        this.count = marker;
    }

    public byte[] toByteArray() {
        if (this.count == 0) {
            return ZERO_BYTES;
        }
        byte[] newbuf = new byte[this.count];
        System.arraycopy(this.buf, 0, newbuf, 0, this.count);
        return newbuf;
    }

    public String toString() {
        throw new IllegalArgumentException("");
    }

    public String getAsString() {
        return new String(this.buf, 0, this.count);
    }

    public void setLength(int i) {
        this.count = 0;
    }
}

