/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.lang;

import com.tplus.transform.lang.FastStringBuffer;
import com.tplus.transform.lang.Wrapper;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;

public class CharBinaryBuffer
implements Serializable {
    public static final char DOT_DECIMAL_POINT = '.';
    public static final char COMMA_DECIMAL_POINT = ',';
    static byte[] ZERO_BYTES = new byte[0];
    FastStringBuffer stringCache;
    byte[] buf;
    int bytesCount = 0;
    int capacity;
    private String encoding;
    boolean alwaysUseByteLength;

    public CharBinaryBuffer() {
        this(16);
    }

    public CharBinaryBuffer(int capacity) {
        this.buf = ZERO_BYTES;
        this.stringCache = new FastStringBuffer(capacity);
        this.capacity = capacity;
    }

    public CharBinaryBuffer(int capacity, String encoding) {
        this.setEncoding(encoding);
        this.buf = ZERO_BYTES;
        this.capacity = capacity;
        this.stringCache = new FastStringBuffer(capacity);
    }

    public boolean isAlwaysUseByteLength() {
        return this.alwaysUseByteLength;
    }

    public void setAlwaysUseByteLength(boolean alwaysUseByteLength) {
        this.alwaysUseByteLength = alwaysUseByteLength;
    }

    void ensureFree(int length) {
        this.expandCapacity(this.bytesCount + length);
    }

    void expandCapacity(int newcount) {
        if (newcount > this.buf.length) {
            byte[] newbuf = new byte[Math.max(Math.max(this.buf.length, this.capacity) << 1, newcount)];
            System.arraycopy(this.buf, 0, newbuf, 0, this.bytesCount);
            this.buf = newbuf;
        }
    }

    public boolean isEmpty() {
        return this.bytesCount != 0 || this.stringCache.length() != 0;
    }

    public int length() {
        if (!this.alwaysUseByteLength) {
            return this.stringCache.length() + this.bytesCount;
        }
        this.flushString();
        return this.bytesCount;
    }

    public void chop(int marker) {
        if (this.bytesCount == 0) {
            if (this.stringCache.length() >= marker) {
                this.stringCache.setLength(marker);
            }
            return;
        }
        this.flushString();
        this.setBytesCount(marker);
    }

    public byte[] toByteArray() {
        this.flushString();
        if (this.bytesCount == 0) {
            return ZERO_BYTES;
        }
        if (this.bytesCount == this.buf.length) {
            return this.buf;
        }
        byte[] newbuf = new byte[this.bytesCount];
        System.arraycopy(this.buf, 0, newbuf, 0, this.bytesCount);
        return newbuf;
    }

    public Object getStringOrBytes() {
        if (this.isBinaryData()) {
            return this.toByteArray();
        }
        return this.getAsString();
    }

    public void write(int byteVal) {
        this.flushString();
        this.ensureFree(1);
        this.buf[this.bytesCount] = (byte)byteVal;
        this.setBytesCount(this.bytesCount + 1);
    }

    void setBytesCount(int bytesCount) {
        this.bytesCount = bytesCount;
        if (bytesCount != 0) {
            // empty if block
        }
    }

    public void insert(int index, String toInsert) {
        if (this.bytesCount > 0) {
            this.flushString();
        }
        this.insert0(index, toInsert);
    }

    public void insert(int index, byte[] toInsert) {
        this.flushString();
        this.insert0(index, toInsert);
    }

    public void append(CharBinaryBuffer toAdd) {
        if (toAdd.isBinaryData()) {
            toAdd.flushString();
            this.flushString();
            int len = toAdd.length();
            this.ensureFree(len);
            System.arraycopy(toAdd.buf, 0, this.buf, this.bytesCount, len);
            this.setBytesCount(this.bytesCount + len);
        } else {
            this.stringCache.append(toAdd.stringCache);
        }
    }

    public void write(byte[] toAdd) {
        this.flushString();
        this.append0(toAdd);
    }

    public void append(byte[] toAdd) {
        this.flushString();
        this.append0(toAdd);
    }

    public void append(byte[] toAdd, int offset, int length) {
        this.flushString();
        this.append0(toAdd, offset, length);
    }

    public void appendStringOrBytes(Object toAdd) {
        if (toAdd instanceof byte[]) {
            this.append((byte[])toAdd);
        }
        this.append((String)toAdd);
    }

    private void insert0(int index, byte[] toAdd) {
        int len = toAdd.length;
        this.ensureFree(len);
        System.arraycopy(this.buf, index, this.buf, index + len, this.bytesCount - index);
        System.arraycopy(toAdd, 0, this.buf, index, len);
        this.setBytesCount(this.bytesCount + len);
    }

    private void append0(byte[] toAdd) {
        this.append0(toAdd, 0, toAdd.length);
    }

    private void append0(byte[] toAdd, int offset, int length) {
        this.ensureFree(length);
        System.arraycopy(toAdd, offset, this.buf, this.bytesCount, length);
        this.setBytesCount(this.bytesCount + length);
    }

    void flushString() {
        if (this.stringCache.length() > 0) {
            byte[] bytes;
            try {
                bytes = CharBinaryBuffer.stringToBytes(this.stringCache.toString(), this.encoding);
            }
            catch (UnsupportedEncodingException e) {
                bytes = this.stringCache.toString().getBytes();
                e.printStackTrace();
            }
            if (this.bytesCount == 0) {
                this.buf = bytes;
                this.setBytesCount(this.buf.length);
            } else {
                this.append0(bytes);
            }
            this.stringCache.setLength(0);
        }
    }

    public void append(CharSequence csq) {
        this.stringCache.append(csq);
    }

    public void append(CharSequence csq, int start, int end) {
        this.stringCache.append(csq, start, end);
    }

    public void append(char c) {
        this.stringCache.append(c);
    }

    public void append(char c, int repeat) {
        this.stringCache.append(c, repeat);
    }

    public void append(int i) {
        this.append(Wrapper.toString(i));
    }

    public void append(long l) {
        this.append(String.valueOf(l));
    }

    public void append(float f, char decimalPoint) {
        String valueStr = String.valueOf(f);
        if (decimalPoint != '.') {
            valueStr = valueStr.replace('.', decimalPoint);
        }
        this.append(valueStr);
    }

    public void append(float f) {
        this.append(String.valueOf(f));
    }

    public void append(double d, char decimalPoint) {
        String valueStr = String.valueOf(d);
        if (decimalPoint != '.') {
            valueStr = valueStr.replace('.', decimalPoint);
        }
        this.append(valueStr);
    }

    public void append(double d) {
        this.append(String.valueOf(d));
    }

    public void append(String str) {
        this.append0(str);
    }

    public void appendDelimiter(String str) {
        this.append0(str);
    }

    public void append(FastStringBuffer str) {
        this.stringCache.append(str);
    }

    public void append(StringBuffer str) {
        this.stringCache.append(str);
    }

    public void append(char[] str) {
        this.stringCache.append(str);
    }

    private void append0(String str) {
        this.stringCache.append(str);
    }

    private void insert0(int index, String str) {
        if (this.bytesCount == 0) {
            this.stringCache.insert(index, str);
        } else {
            byte[] bytes;
            this.flushString();
            try {
                bytes = CharBinaryBuffer.stringToBytes(str, this.encoding);
            }
            catch (UnsupportedEncodingException e) {
                bytes = str.getBytes();
                e.printStackTrace();
            }
            this.insert0(index, bytes);
        }
    }

    public String toString() {
        return this.getAsString();
    }

    public String getAsString() {
        if (this.isBinaryData()) {
            this.flushString();
            if (this.encoding == null) {
                return new String(this.buf, 0, this.bytesCount);
            }
            try {
                return new String(this.buf, 0, this.bytesCount, this.encoding);
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
                return new String(this.buf, 0, this.bytesCount);
            }
        }
        return this.stringCache.toString();
    }

    public boolean isBinaryData() {
        return this.bytesCount > 0;
    }

    public Object getAsObject() {
        if (this.isBinaryData()) {
            return this.toByteArray();
        }
        return this.getAsString();
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setEncoding(String encoding, boolean mixedFormat) {
        this.encoding = encoding;
        if (mixedFormat) {
            this.alwaysUseByteLength = this.isMultiByteEncoding(encoding);
        }
    }

    private boolean isMultiByteEncoding(String encoding) {
        return encoding != null && encoding.toLowerCase().startsWith("utf");
    }

    public void setLength(int i) {
        this.stringCache.clear();
        this.setBytesCount(0);
    }

    public void clear() {
        this.stringCache.clear();
        this.setBytesCount(0);
    }

    public static void verifyEncoding(String encodingForMessage) throws UnsupportedEncodingException {
        if (encodingForMessage != null) {
            "a".getBytes(encodingForMessage);
        }
    }

    public static byte[] stringToBytes(String str) {
        return str.getBytes();
    }

    public static byte[] stringToBytes(String str, String encoding) throws UnsupportedEncodingException {
        if (str == null) {
            return new byte[0];
        }
        if (encoding == null) {
            return str.getBytes();
        }
        return str.getBytes(encoding);
    }

    public static String bytesToString(byte[] bytes, String encoding) throws UnsupportedEncodingException {
        if (encoding == null) {
            return new String(bytes);
        }
        return new String(bytes, encoding);
    }

    public static String bytesToString(byte[] bytes, int startIndex, int length, String encoding) throws UnsupportedEncodingException {
        if (encoding == null) {
            return new String(bytes, startIndex, length);
        }
        return new String(bytes, startIndex, length, encoding);
    }

    public static String bytesToString(byte[] bytes) {
        return new String(bytes);
    }
}

