/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.lang;

import com.tplus.transform.lang.FastStringBuffer;
import com.tplus.transform.lang.FloatingDecimal;
import com.tplus.transform.lang.ScaledDecimal;

public class DoubleUtils {
    public static long[] PowersOf10 = new long[]{1L, 10L, 100L, 1000L, 10000L, 100000L, 1000000L, 10000000L, 100000000L, 1000000000L, 10000000000L, 100000000000L, 1000000000000L, 10000000000000L, 100000000000000L, 1000000000000000L, 10000000000000000L, 100000000000000000L, 1000000000000000000L};

    public static String toString(double db, int digits, char decimalPoint, boolean alwaysUseDecimalPoint, boolean alwaysUseDecimalComponent) {
        NumberFormatInfo numberFormatInfo = new NumberFormatInfo();
        numberFormatInfo.setMaxDigits(digits);
        numberFormatInfo.setDecimalPoint(decimalPoint);
        numberFormatInfo.setAlwaysUseDecimalPoint(alwaysUseDecimalPoint);
        numberFormatInfo.setAlwaysUseDecimalComponent(alwaysUseDecimalComponent);
        return DoubleUtils.toString(db, numberFormatInfo);
    }

    public static String toString(float db, int digits, char decimalPoint, boolean alwaysUseDecimalPoint, boolean alwaysUseDecimalComponent) {
        NumberFormatInfo numberFormatInfo = new NumberFormatInfo();
        numberFormatInfo.setMaxDigits(digits);
        numberFormatInfo.setDecimalPoint(decimalPoint);
        numberFormatInfo.setAlwaysUseDecimalPoint(alwaysUseDecimalPoint);
        numberFormatInfo.setAlwaysUseDecimalComponent(alwaysUseDecimalComponent);
        return DoubleUtils.toString(db, numberFormatInfo);
    }

    public static String toString(double db, NumberFormatInfo numberFormatInfo) {
        FloatingDecimal floatingDecimal = new FloatingDecimal(db);
        floatingDecimal.setMaxDigits(numberFormatInfo.getMaxDigits());
        floatingDecimal.setDecimalPoint(numberFormatInfo.getDecimalPoint());
        floatingDecimal.setAlwaysUseDecimalPoint(numberFormatInfo.isAlwaysUseDecimalPoint());
        floatingDecimal.setAlwaysUseDecimalComponent(numberFormatInfo.isAlwaysUseDecimalComponent());
        return floatingDecimal.toJavaFormatString();
    }

    public static String toString(float db, NumberFormatInfo numberFormatInfo) {
        FloatingDecimal floatingDecimal = new FloatingDecimal(db);
        floatingDecimal.setMaxDigits(numberFormatInfo.getMaxDigits());
        floatingDecimal.setDecimalPoint(numberFormatInfo.getDecimalPoint());
        floatingDecimal.setAlwaysUseDecimalPoint(numberFormatInfo.isAlwaysUseDecimalPoint());
        floatingDecimal.setAlwaysUseDecimalComponent(numberFormatInfo.isAlwaysUseDecimalComponent());
        return floatingDecimal.toJavaFormatString();
    }

    public static ScaledDecimal toScaledDecimal(double db) {
        ScaledDecimal decimal = new ScaledDecimal();
        DoubleUtils.toScaledDecimal(db, decimal);
        return decimal;
    }

    public static ScaledDecimal toScaledDecimal(double db, ScaledDecimal decimal) {
        FloatingDecimal floatingDecimal = new FloatingDecimal(db);
        floatingDecimal.setMaxDigits(25);
        floatingDecimal.setDecimalPoint('.');
        floatingDecimal.setAlwaysUseDecimalPoint(true);
        floatingDecimal.setAlwaysUseDecimalComponent(true);
        floatingDecimal.toScaledDecimal(decimal);
        return decimal;
    }

    public static ScaledDecimal toScaledDecimal(String db) {
        return DoubleUtils.toScaledDecimal(db, new ScaledDecimal());
    }

    public static ScaledDecimal toScaledDecimal(String value, ScaledDecimal decimal) throws NumberFormatException {
        int exponent;
        String str;
        if (value != null && value.length() > 0 && value.charAt(0) == '+') {
            value = value.substring(1);
        }
        int dotIndex = value.indexOf(46);
        int lastNonZeroIndex = 0;
        if (dotIndex != -1) {
            str = value.substring(0, dotIndex) + value.substring(dotIndex + 1);
            exponent = -(value.length() - (dotIndex + 1));
        } else {
            str = value;
            exponent = 0;
        }
        if (str.length() > 18) {
            for (int i = str.length() - 1; i >= 0; --i) {
                if (str.charAt(i) == '0') continue;
                lastNonZeroIndex = i + 1;
                if (lastNonZeroIndex == str.length()) break;
                exponent += str.length() - lastNonZeroIndex;
                str = str.substring(0, lastNonZeroIndex);
                break;
            }
        }
        long mantissa = Long.parseLong(str);
        decimal.setMantissaExponent(mantissa, exponent);
        return decimal;
    }

    public static void appendDoubleValue(double value, int width, char decimalPoint, boolean lpad, char paddingChar, FastStringBuffer buffer) {
        FastStringBuffer tempBuffer = new FastStringBuffer();
        if (value < 0.0) {
            buffer.append('-');
            value = -value;
            --width;
        }
        long numberValue = Math.abs((long)value);
        double decimalValue = value - (double)numberValue;
        tempBuffer.append(numberValue);
        int numberLength = tempBuffer.length();
        int decimalDigits = Math.max(width - numberLength - 1, 0);
        long POWER10Decimals = PowersOf10[decimalDigits];
        long decimalIntValue = Math.round(decimalValue * (double)POWER10Decimals);
        if (decimalIntValue == POWER10Decimals) {
            decimalIntValue = 0L;
            tempBuffer.setLength(0);
            tempBuffer.append(++numberValue);
            numberLength = tempBuffer.length();
            decimalDigits = width - numberLength - 1;
        }
        if (numberLength > width) {
            throw new IllegalArgumentException("Cannot represent " + value + " in " + width + " digits");
        }
        if (decimalIntValue == 0L) {
            DoubleUtils.appendPaddingChar(width - tempBuffer.length(), paddingChar, buffer);
            buffer.append(tempBuffer);
        } else {
            buffer.append(tempBuffer);
            buffer.append(decimalPoint);
            DoubleUtils.appendPaddedLong(Math.abs(decimalIntValue), false, decimalDigits, true, '0', buffer);
        }
    }

    private static void appendPaddedLong(long value, boolean negative, int width, boolean lpad, char paddingChar, FastStringBuffer buffer) {
        String valueStr = Long.toString(value);
        int strLength = valueStr.length() + (negative ? 1 : 0);
        if (strLength > width) {
            throw new IllegalArgumentException("Cannot represent " + value + " in " + width + " digits");
        }
        if (lpad) {
            if (negative && paddingChar == '0') {
                buffer.append('-');
            }
            DoubleUtils.appendPaddingChar(width - strLength, paddingChar, buffer);
            if (negative && paddingChar != '0') {
                buffer.append('-');
            }
            buffer.append(valueStr);
        } else {
            if (negative) {
                buffer.append('-');
            }
            buffer.append(valueStr);
            DoubleUtils.appendPaddingChar(width - strLength, paddingChar, buffer);
        }
    }

    private static void appendPaddingChar(int length, char paddingChar, FastStringBuffer buffer) {
        if (length > 0) {
            DoubleUtils.appendChar0(length, paddingChar, buffer);
        }
    }

    private static void appendChar0(int length, char c, FastStringBuffer buffer) {
        for (int i = 0; i < length; ++i) {
            buffer.append(c);
        }
    }

    public static void cmtmain(String[] args) {
        ScaledDecimal decimal = new ScaledDecimal();
        DoubleUtils.toScaledDecimal(10.5, decimal);
        System.out.println(decimal);
        DoubleUtils.toScaledDecimal(105.0, decimal);
        System.out.println(decimal);
        DoubleUtils.toScaledDecimal(0.0, decimal);
        System.out.println(decimal);
        DoubleUtils.toScaledDecimal(100.0, decimal);
        System.out.println(decimal);
        DoubleUtils.toScaledDecimal(1024.77, decimal);
        System.out.println(decimal);
        DoubleUtils.toScaledDecimal(1024.779213, decimal);
        System.out.println(decimal);
        DoubleUtils.toScaledDecimal(1.1, decimal);
        System.out.println(decimal);
        DoubleUtils.toScaledDecimal(1.12345678912345, decimal);
        System.out.println(decimal);
        DoubleUtils.toScaledDecimal(0.1, decimal);
        System.out.println(decimal);
        DoubleUtils.toScaledDecimal(0.001, decimal);
        System.out.println(decimal);
        DoubleUtils.toScaledDecimal(2.147483647E9, decimal);
        System.out.println(decimal);
        DoubleUtils.toScaledDecimal(-2.147483648E9, decimal);
        System.out.println(decimal);
        DoubleUtils.toScaledDecimal(3.147483641111E12, decimal);
        System.out.println(decimal);
        DoubleUtils.toScaledDecimal(1.0E-16, decimal);
        System.out.println(decimal);
        DoubleUtils.toScaledDecimal(1.223E-20, decimal);
        System.out.println(decimal);
    }

    public static class NumberFormatInfo {
        int maxDigits = 8;
        char decimalPoint = (char)46;
        private boolean alwaysUseDecimalPoint = true;
        private boolean alwaysUseDecimalComponent = true;

        public int getMaxDigits() {
            return this.maxDigits;
        }

        public void setMaxDigits(int maxDigits) {
            this.maxDigits = maxDigits;
        }

        public char getDecimalPoint() {
            return this.decimalPoint;
        }

        public void setDecimalPoint(char decimalPoint) {
            this.decimalPoint = decimalPoint;
        }

        public boolean isAlwaysUseDecimalPoint() {
            return this.alwaysUseDecimalPoint;
        }

        public void setAlwaysUseDecimalPoint(boolean alwaysUseDecimalPoint) {
            this.alwaysUseDecimalPoint = alwaysUseDecimalPoint;
        }

        public boolean isAlwaysUseDecimalComponent() {
            return this.alwaysUseDecimalComponent;
        }

        public void setAlwaysUseDecimalComponent(boolean alwaysUseDecimalComponent) {
            this.alwaysUseDecimalComponent = alwaysUseDecimalComponent;
        }
    }
}

