/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.lang;

import com.tplus.transform.lang.Wrapper;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;

public class FastStringBuffer
implements Serializable,
CharSequence {
    public static final int MB5 = 0x500000;
    private char[] value;
    private int count;
    static final long serialVersionUID = 1228685877147921107L;
    private static final FastStringBuffer NULL = new FastStringBuffer("null");
    private static final StringBuffer NULL_STR_BUF = new StringBuffer("null");

    public FastStringBuffer() {
        this(16);
    }

    public FastStringBuffer(int length) {
        this.value = new char[length];
    }

    public FastStringBuffer(String str) {
        this(str.length() + 16);
        this.append(str);
    }

    @Override
    public int length() {
        return this.count;
    }

    public int capacity() {
        return this.value.length;
    }

    public void ensureCapacity(int minimumCapacity) {
        if (minimumCapacity > this.value.length) {
            this.expandCapacity(minimumCapacity);
        }
    }

    private void expandCapacity(int minimumCapacity) {
        int newCapacity = (this.value.length + 1) * 2;
        if (newCapacity < 0) {
            newCapacity = Integer.MAX_VALUE;
        } else if (minimumCapacity > newCapacity) {
            newCapacity = minimumCapacity + 100;
        }
        if (newCapacity - minimumCapacity > 0x500000) {
            newCapacity = minimumCapacity + 0x500000;
        }
        char[] newValue = new char[newCapacity];
        System.arraycopy(this.value, 0, newValue, 0, this.count);
        this.value = newValue;
    }

    public void setLength(int newLength) {
        if (newLength == 0) {
            this.clear();
        } else {
            if (newLength < 0) {
                throw new StringIndexOutOfBoundsException(newLength);
            }
            if (newLength > this.value.length) {
                this.expandCapacity(newLength);
            }
            if (this.count < newLength) {
                while (this.count < newLength) {
                    this.value[this.count] = '\u0000';
                    ++this.count;
                }
            } else {
                this.count = newLength;
            }
        }
    }

    public void clear() {
        this.count = 0;
    }

    public void trimToSize() {
        if (this.count < this.value.length) {
            char[] newValue = new char[this.count];
            System.arraycopy(this.value, 0, newValue, 0, this.count);
            this.value = newValue;
        }
    }

    @Override
    public char charAt(int index) {
        if (index < 0 || index >= this.count) {
            throw new StringIndexOutOfBoundsException(index);
        }
        return this.value[index];
    }

    public void getChars(int srcBegin, int srcEnd, char[] dst, int dstBegin) {
        if (srcBegin < 0) {
            throw new StringIndexOutOfBoundsException(srcBegin);
        }
        if (srcEnd < 0 || srcEnd > this.count) {
            throw new StringIndexOutOfBoundsException(srcEnd);
        }
        if (srcBegin > srcEnd) {
            throw new StringIndexOutOfBoundsException("srcBegin > srcEnd");
        }
        System.arraycopy(this.value, srcBegin, dst, dstBegin, srcEnd - srcBegin);
    }

    public void setCharAt(int index, char ch) {
        if (index < 0 || index >= this.count) {
            throw new StringIndexOutOfBoundsException(index);
        }
        this.value[index] = ch;
    }

    public FastStringBuffer append(Object obj) {
        return this.append(String.valueOf(obj));
    }

    public FastStringBuffer append(CharSequence s) {
        if (s instanceof String) {
            return this.append((String)s);
        }
        if (s instanceof StringBuffer) {
            return this.append((StringBuffer)s);
        }
        return this.append(s, 0, s.length());
    }

    public FastStringBuffer append(CharSequence s, int start, int end) {
        if (s == null) {
            s = "null";
        }
        if (start < 0 || end < 0 || start > end || end > s.length()) {
            throw new IndexOutOfBoundsException("start " + start + ", end " + end + ", s.length() " + s.length());
        }
        int len = end - start;
        if (len == 0) {
            return this;
        }
        int newCount = this.count + len;
        if (newCount > this.value.length) {
            this.expandCapacity(newCount);
        }
        for (int i = start; i < end; ++i) {
            this.value[this.count++] = s.charAt(i);
        }
        this.count = newCount;
        return this;
    }

    public FastStringBuffer append(String str) {
        int len;
        int newcount;
        if (str == null) {
            str = String.valueOf(str);
        }
        if ((newcount = this.count + (len = str.length())) > this.value.length) {
            this.expandCapacity(newcount);
        }
        str.getChars(0, len, this.value, this.count);
        this.count = newcount;
        return this;
    }

    public FastStringBuffer append(String str, int start, int length) {
        int newcount;
        if (str == null) {
            str = String.valueOf(str);
        }
        if ((newcount = this.count + length) > this.value.length) {
            this.expandCapacity(newcount);
        }
        str.getChars(start, start + length, this.value, this.count);
        this.count = newcount;
        return this;
    }

    public FastStringBuffer append(FastStringBuffer sb) {
        int len;
        int newcount;
        if (sb == null) {
            sb = NULL;
        }
        if ((newcount = this.count + (len = sb.length())) > this.value.length) {
            this.expandCapacity(newcount);
        }
        sb.getChars(0, len, this.value, this.count);
        this.count = newcount;
        return this;
    }

    public FastStringBuffer append(StringBuffer sb) {
        int len;
        int newcount;
        if (sb == null) {
            sb = NULL_STR_BUF;
        }
        if ((newcount = this.count + (len = sb.length())) > this.value.length) {
            this.expandCapacity(newcount);
        }
        sb.getChars(0, len, this.value, this.count);
        this.count = newcount;
        return this;
    }

    public FastStringBuffer append(char[] str) {
        int len = str.length;
        int newcount = this.count + len;
        if (newcount > this.value.length) {
            this.expandCapacity(newcount);
        }
        System.arraycopy(str, 0, this.value, this.count, len);
        this.count = newcount;
        return this;
    }

    public FastStringBuffer append(char[] str, int offset, int len) {
        int newcount = this.count + len;
        if (newcount > this.value.length) {
            this.expandCapacity(newcount);
        }
        System.arraycopy(str, offset, this.value, this.count, len);
        this.count = newcount;
        return this;
    }

    public FastStringBuffer append(byte[] ascii) {
        return this.append(ascii, 0, ascii.length);
    }

    public FastStringBuffer append(byte[] ascii, int offset, int len) {
        int newcount = this.count + len;
        if (newcount > this.value.length) {
            this.expandCapacity(newcount);
        }
        int i = len;
        while (i-- > 0) {
            this.value[i + this.count] = (char)ascii[i + offset];
        }
        this.count = newcount;
        return this;
    }

    public FastStringBuffer append(boolean b) {
        return this.append(String.valueOf(b));
    }

    public FastStringBuffer append(char c) {
        int newcount = this.count + 1;
        if (newcount > this.value.length) {
            this.expandCapacity(newcount);
        }
        this.value[this.count++] = c;
        return this;
    }

    public void appendChar(char c) {
        int newcount = this.count + 1;
        if (newcount > this.value.length) {
            this.expandCapacity(newcount);
        }
        this.value[this.count++] = c;
    }

    public FastStringBuffer append(char c, int repeat) {
        int newcount = this.count + repeat;
        if (newcount > this.value.length) {
            this.expandCapacity(newcount);
        }
        for (int i = this.count; i < newcount; ++i) {
            this.value[i] = c;
        }
        this.count = newcount;
        return this;
    }

    public FastStringBuffer append(int i) {
        return this.append(Wrapper.toString(i));
    }

    public FastStringBuffer append(long l) {
        return this.append(String.valueOf(l));
    }

    public FastStringBuffer append(float f) {
        return this.append(String.valueOf(f));
    }

    public FastStringBuffer append(double d) {
        return this.append(String.valueOf(d));
    }

    public FastStringBuffer delete(int start, int end) {
        if (start < 0) {
            throw new StringIndexOutOfBoundsException(start);
        }
        if (end > this.count) {
            end = this.count;
        }
        if (start > end) {
            throw new StringIndexOutOfBoundsException();
        }
        int len = end - start;
        if (len > 0) {
            System.arraycopy(this.value, start + len, this.value, start, this.count - end);
            this.count -= len;
        }
        return this;
    }

    public FastStringBuffer deleteCharAt(int index) {
        if (index < 0 || index >= this.count) {
            throw new StringIndexOutOfBoundsException();
        }
        System.arraycopy(this.value, index + 1, this.value, index, this.count - index - 1);
        --this.count;
        return this;
    }

    public FastStringBuffer replace(int start, int end, String str) {
        if (start < 0) {
            throw new StringIndexOutOfBoundsException(start);
        }
        if (end > this.count) {
            end = this.count;
        }
        if (start > end) {
            throw new StringIndexOutOfBoundsException();
        }
        int len = str.length();
        int newCount = this.count + len - (end - start);
        if (newCount > this.value.length) {
            this.expandCapacity(newCount);
        }
        System.arraycopy(this.value, end, this.value, start + len, this.count - end);
        str.getChars(0, len, this.value, start);
        this.count = newCount;
        return this;
    }

    public String substring(int start) {
        return this.substring(start, this.count);
    }

    public String substring(int start, int end) {
        if (start < 0) {
            throw new StringIndexOutOfBoundsException(start);
        }
        if (end > this.count) {
            throw new StringIndexOutOfBoundsException(end);
        }
        if (start > end) {
            throw new StringIndexOutOfBoundsException(end - start);
        }
        return new String(this.value, start, end - start);
    }

    public FastStringBuffer insert(int index, char[] str, int offset, int len) {
        if (index < 0 || index > this.count) {
            throw new StringIndexOutOfBoundsException();
        }
        if (offset < 0 || offset + len < 0 || offset + len > str.length) {
            throw new StringIndexOutOfBoundsException(offset);
        }
        if (len < 0) {
            throw new StringIndexOutOfBoundsException(len);
        }
        int newCount = this.count + len;
        if (newCount > this.value.length) {
            this.expandCapacity(newCount);
        }
        System.arraycopy(this.value, index, this.value, index + len, this.count - index);
        System.arraycopy(str, offset, this.value, index, len);
        this.count = newCount;
        return this;
    }

    public FastStringBuffer insert(int offset, Object obj) {
        return this.insert(offset, String.valueOf(obj));
    }

    public FastStringBuffer insert(int offset, String str) {
        int len;
        int newcount;
        if (offset < 0 || offset > this.count) {
            throw new StringIndexOutOfBoundsException();
        }
        if (str == null) {
            str = String.valueOf(str);
        }
        if ((newcount = this.count + (len = str.length())) > this.value.length) {
            this.expandCapacity(newcount);
        }
        System.arraycopy(this.value, offset, this.value, offset + len, this.count - offset);
        str.getChars(0, len, this.value, offset);
        this.count = newcount;
        return this;
    }

    public FastStringBuffer insert(int offset, char[] str) {
        if (offset < 0 || offset > this.count) {
            throw new StringIndexOutOfBoundsException();
        }
        int len = str.length;
        int newcount = this.count + len;
        if (newcount > this.value.length) {
            this.expandCapacity(newcount);
        }
        System.arraycopy(this.value, offset, this.value, offset + len, this.count - offset);
        System.arraycopy(str, 0, this.value, offset, len);
        this.count = newcount;
        return this;
    }

    public FastStringBuffer insert(int offset, boolean b) {
        return this.insert(offset, String.valueOf(b));
    }

    public FastStringBuffer insert(int offset, char c) {
        int newcount = this.count + 1;
        if (newcount > this.value.length) {
            this.expandCapacity(newcount);
        }
        System.arraycopy(this.value, offset, this.value, offset + 1, this.count - offset);
        this.value[offset] = c;
        this.count = newcount;
        return this;
    }

    public FastStringBuffer insert(int offset, int i) {
        return this.insert(offset, String.valueOf(i));
    }

    public FastStringBuffer insert(int offset, long l) {
        return this.insert(offset, String.valueOf(l));
    }

    public FastStringBuffer insert(int offset, float f) {
        return this.insert(offset, String.valueOf(f));
    }

    public FastStringBuffer insert(int offset, double d) {
        return this.insert(offset, String.valueOf(d));
    }

    public FastStringBuffer reverse() {
        int n = this.count - 1;
        for (int j = n - 1 >> 1; j >= 0; --j) {
            char temp = this.value[j];
            this.value[j] = this.value[n - j];
            this.value[n - j] = temp;
        }
        return this;
    }

    @Override
    public String toString() {
        return new String(this.value, 0, this.count);
    }

    final char[] getValue() {
        return this.value;
    }

    public void getBytes(int srcBegin, int srcEnd, byte[] dst, int dstBegin) {
        if (srcBegin < 0) {
            throw new StringIndexOutOfBoundsException(srcBegin);
        }
        if (srcEnd > this.count) {
            throw new StringIndexOutOfBoundsException(srcEnd);
        }
        if (srcBegin > srcEnd) {
            throw new StringIndexOutOfBoundsException(srcEnd - srcBegin);
        }
        int j = dstBegin;
        int n = srcEnd;
        int i = srcBegin;
        char[] val = this.value;
        while (i < n) {
            dst[j++] = (byte)val[i++];
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.substring(start, end);
    }
}

