/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.lang;

import com.tplus.transform.lang.GenericObjectPool;
import com.tplus.transform.lang.ObjectFactory;
import com.tplus.transform.lang.ObjectPool;
import java.util.ArrayList;
import java.util.List;

public class ObjectPoolTest {
    private static int WORK = 0;
    private static int THREADS = 4;

    public static void cmtmain(String[] args) {
        final ArrayList objects = new ArrayList();
        ObjectFactory factory = new ObjectFactory(){
            int objectIndex;

            @Override
            public Object create() throws IllegalAccessException, InstantiationException {
                MyObject myObject = new MyObject("Object " + ++this.objectIndex);
                objects.add(myObject);
                return myObject;
            }
        };
        System.out.println("Volante -------");
        GenericObjectPool genericObjectPool = new GenericObjectPool(factory);
        ObjectPoolTest.testPool(THREADS, genericObjectPool);
        ObjectPoolTest.monitorApp(objects);
    }

    private static void monitorApp(List objects) {
        long previousCalls = ObjectPoolTest.countCalls(objects);
        long time = System.currentTimeMillis();
        boolean stop = false;
        while (!stop) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            long calls = ObjectPoolTest.countCalls(objects);
            long endtime = System.currentTimeMillis();
            System.out.println("Object = " + objects.size() + ", Calls = " + calls + " at " + (calls - previousCalls) * 1000L / (endtime - time));
        }
    }

    private static long countCalls(List objects) {
        long calls = 0L;
        for (Object object : objects) {
            MyObject myObject = (MyObject)object;
            calls += myObject.calls;
        }
        return calls;
    }

    static void testPool(int count, final ObjectPool pool) {
        Thread[] threads = new Thread[count];
        for (int i = 0; i < count; ++i) {
            threads[i] = new Thread("Th " + (i + 1)){
                int total;

                @Override
                public void run() {
                    try {
                        while (true) {
                            MyObject objectFromPool = (MyObject)pool.getObjectFromPool();
                            this.total += this.testObj(objectFromPool);
                            pool.releaseObjectToPool(objectFromPool);
                        }
                    }
                    catch (IllegalAccessException | InstantiationException e) {
                        e.printStackTrace();
                        return;
                    }
                }

                private int testObj(MyObject myObject) {
                    int length = myObject.getName().length();
                    int work = WORK * 1000;
                    for (int i = 0; i < work; ++i) {
                        length += 2;
                    }
                    myObject.call();
                    return length;
                }
            };
        }
        for (Thread thread : threads) {
            thread.start();
        }
    }

    static class MyObject {
        long calls;
        String name;

        MyObject(String name) {
            this.name = name;
        }

        void call() {
            ++this.calls;
        }

        public String getName() {
            return this.name;
        }
    }
}

