/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.lang;

import com.tplus.transform.lang.AbstractPoolingProxy;
import com.tplus.transform.lang.ObjectFactory;
import com.tplus.transform.lang.ObjectPool;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

public class PoolingProxyImpl
extends AbstractPoolingProxy
implements InvocationHandler {
    public PoolingProxyImpl(Class actualClass, Class interfaceClass) {
        super(actualClass, interfaceClass);
    }

    public PoolingProxyImpl(ObjectFactory objectFactory, Class interfaceClass) {
        super(objectFactory, interfaceClass);
    }

    public PoolingProxyImpl(ObjectPool objectPool, Class interfaceClass) {
        super(objectPool, interfaceClass);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Object actualObject = this.getObjectFromPoolForCall(method);
        try {
            Object object = method.invoke(actualObject, args);
            return object;
        }
        catch (InvocationTargetException e) {
            throw e.getTargetException();
        }
        finally {
            this.releaseObjectToPool(actualObject, method);
        }
    }

    @Override
    protected Object createProxy() {
        return Proxy.newProxyInstance(this.interfaceClass.getClassLoader(), new Class[]{this.interfaceClass}, (InvocationHandler)this);
    }
}

