/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.lang;

import java.io.File;
import java.io.PrintWriter;

public class SystemUtil {
    public static final PrintWriter out = new PrintWriter(System.out, true);
    public static final PrintWriter err = new PrintWriter(System.err, true);

    public static String getUserName() {
        return System.getProperty("user.name");
    }

    public static String getUserDir() {
        return System.getProperty("user.dir");
    }

    public static String getTempDir() {
        return System.getProperty("java.io.tmpdir");
    }

    public static void loadLibrary(String name) {
        if (SystemUtil.is64Bit()) {
            name = name + "64";
        }
        try {
            System.loadLibrary(name);
        }
        catch (Error e) {
            String path = new File(new File(System.getProperty("designer.home"), "bin"), name + ".dll").getAbsolutePath();
            System.load(path);
        }
    }

    public static boolean is64Bit() {
        return System.getProperty("os.arch").endsWith("64");
    }
}

