/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.lang.management;

import com.sun.jdmk.comm.HtmlAdaptorServer;
import com.tplus.transform.lang.management.ManagementException;
import com.tplus.transform.lang.management.ManagementFactory;
import com.tplus.transform.util.log.Log;
import com.tplus.transform.util.log.LogFactory;
import java.net.InetAddress;
import java.util.Properties;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.ReflectionException;

public class JdmkAgent {
    protected static Log log = LogFactory.getLog(JdmkAgent.class);
    private String name = "JDMK Agent";
    private Object adaptor;
    private MBeanServer mBeanServer;
    private ObjectName adaptorName;
    int port = 9092;

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    protected Object createAdaptor() throws Exception {
        HtmlAdaptorServer adaptor = new HtmlAdaptorServer(this.port);
        return adaptor;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return "Jdmk Http adaptor: " + this.port;
    }

    public void startService() throws ManagementException {
        try {
            this.mBeanServer.invoke(this.adaptorName, "start", null, null);
        }
        catch (InstanceNotFoundException e) {
            throw new ManagementException("Failed to start adapter");
        }
        catch (MBeanException e) {
            throw new ManagementException("Failed to start adapter Jdmk agent");
        }
        catch (ReflectionException reflectionException) {
            // empty catch block
        }
    }

    public void stopService() throws ManagementException {
        try {
            this.mBeanServer.invoke(this.adaptorName, "stop", null, null);
        }
        catch (InstanceNotFoundException | MBeanException e) {
            throw new ManagementException("Failed to stop Jdmk agent");
        }
        catch (ReflectionException reflectionException) {
            // empty catch block
        }
    }

    public void dispose() {
        try {
            this.stopService();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void registered() {
    }

    public void unregistered() {
    }

    public void init(Properties props) throws ManagementException {
        try {
            String portStr = props.getProperty("port");
            if (portStr != null) {
                this.port = Integer.parseInt(portStr);
            }
            this.mBeanServer = ManagementFactory.getPlatformMBeanServer();
            this.adaptor = this.createAdaptor();
            this.adaptorName = new ObjectName("Adaptor:class=" + this.adaptor.getClass().getName());
            if (!this.mBeanServer.isRegistered(this.adaptorName)) {
                this.mBeanServer.registerMBean(this.adaptor, this.adaptorName);
            }
            this.startService();
            String hostName = InetAddress.getLocalHost().getHostName();
            log.info("JMX agent started at http://" + hostName + ":" + this.port);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ManagementException("Failed to start Jdmk Agent" + e.getMessage());
        }
    }
}

