/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.lang.management;

import com.tplus.transform.lang.management.ManagementException;
import com.tplus.transform.lang.management.ManagementFactory;
import java.util.Iterator;
import java.util.Set;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import org.apache.log4j.jmx.HierarchyDynamicMBean;

public class Log4jAgent {
    private String name = "Log4j Agent";
    private MBeanServer mBeanServer;
    public static final String JMX_OBJECT_NAME = "log4j:type=Hierarchy";

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return "Log4j JMX Agent";
    }

    public void initialize() throws ManagementException {
        try {
            this.mBeanServer = ManagementFactory.getPlatformMBeanServer();
            ObjectName objectName = ObjectName.getInstance(JMX_OBJECT_NAME);
            this.unregisterMBeansIfNecessary();
            this.mBeanServer.registerMBean(new HierarchyDynamicMBean(), objectName);
        }
        catch (Exception e) {
            throw new ManagementException("Failed to start JMX Agent");
        }
    }

    protected void unregisterMBeansIfNecessary() throws MalformedObjectNameException, InstanceNotFoundException, MBeanRegistrationException {
        if (this.mBeanServer.isRegistered(ObjectName.getInstance(JMX_OBJECT_NAME))) {
            Set<ObjectInstance> log4jMBeans = this.mBeanServer.queryMBeans(ObjectName.getInstance("log4j*:*"), null);
            Iterator<ObjectInstance> iterator = log4jMBeans.iterator();
            while (iterator.hasNext()) {
                ObjectInstance log4jMBean;
                ObjectInstance objectInstance = log4jMBean = iterator.next();
                ObjectName theName = objectInstance.getObjectName();
                this.mBeanServer.unregisterMBean(theName);
            }
        }
    }
}

