/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.lang.pool;

import com.tplus.transform.lang.ObjectFactory;
import com.tplus.transform.lang.ObjectPool;
import com.tplus.transform.lang.pool.GenericObjectPool;
import com.tplus.transform.lang.pool.PoolableObjectFactory;

public class CommonsGenericObjectPool
implements ObjectPool {
    GenericObjectPool pool;

    public CommonsGenericObjectPool(final ObjectFactory objectFactory) {
        PoolableObjectFactory poolableObjectFactory = new PoolableObjectFactory(){

            public Object makeObject() throws Exception {
                return objectFactory.create();
            }

            public void destroyObject(Object o) throws Exception {
            }

            public boolean validateObject(Object o) {
                return true;
            }

            public void activateObject(Object o) throws Exception {
            }

            public void passivateObject(Object o) throws Exception {
            }
        };
        this.pool = new GenericObjectPool(poolableObjectFactory, 100, 2, -1L);
    }

    @Override
    public int getFreeObjectCount() {
        return this.pool.getNumIdle();
    }

    @Override
    public int getObjectCount() {
        return this.pool.getNumActive() + this.pool.getNumIdle();
    }

    @Override
    public Object createObjectNoPool() throws IllegalAccessException, InstantiationException {
        try {
            return this.pool.borrowObject();
        }
        catch (Exception e) {
            return this.handleException(e);
        }
    }

    private Object handleException(Exception e) throws InstantiationException, IllegalAccessException {
        if (e instanceof IllegalAccessException) {
            throw (IllegalAccessException)e;
        }
        if (e instanceof InstantiationException) {
            throw (InstantiationException)e;
        }
        IllegalAccessException nexEx = new IllegalAccessException("");
        nexEx.initCause(e);
        throw nexEx;
    }

    @Override
    public Object getObjectFromPool() throws IllegalAccessException, InstantiationException {
        try {
            return this.pool.borrowObject();
        }
        catch (Exception e) {
            return this.handleException(e);
        }
    }

    @Override
    public void releaseObjectToPool(Object actualObject) {
        try {
            this.pool.returnObject(actualObject);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void ensureCapacity(int capacity) throws InstantiationException, IllegalAccessException {
    }

    @Override
    public void invalidateObject(Object object) throws Exception {
        this.pool.invalidateObject(object);
    }

    @Override
    public int getMaxPoolSize() {
        return 0;
    }

    @Override
    public void setMaxPoolSize(int maxPoolSize) {
    }

    @Override
    public int getMaxWaitTime() {
        return (int)this.pool.getMaxWait();
    }

    @Override
    public void setMaxWaitTime(int maxWaitTime) {
        this.pool.setMaxWait(maxWaitTime);
    }

    @Override
    public int getExhaustPolicy() {
        return this.pool.getWhenExhaustedAction();
    }

    @Override
    public void setExhaustPolicy(int exhaustPolicy) {
        this.pool.setWhenExhaustedAction((byte)exhaustPolicy);
    }
}

