/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.security;

import com.tplus.transform.util.StringUtils;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class EmailValidator {
    private static final String EMAIL_PATTERN = "^[_A-Za-z0-9-\\+]+(\\.[_A-Za-z0-9-]+)*@[A-Za-z0-9-]+(\\.[A-Za-z0-9]+)*(\\.[A-Za-z]{2,})$";
    private final Pattern pattern = Pattern.compile("^[_A-Za-z0-9-\\+]+(\\.[_A-Za-z0-9-]+)*@[A-Za-z0-9-]+(\\.[A-Za-z0-9]+)*(\\.[A-Za-z]{2,})$");
    private static Set genericEMails = new HashSet<String>(Arrays.asList("gmail.com", "yahoo.com"));

    public boolean validate(String email) {
        Matcher matcher = this.pattern.matcher(email);
        return matcher.matches();
    }

    public boolean isGenericEmail(String email) {
        String s = StringUtils.rightStr(email, "@");
        return genericEMails.contains(s);
    }
}

