/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.security.codec;

import com.tplus.transform.lang.ObjectUtil;
import com.tplus.transform.lang.Wrapper;
import java.io.IOException;
import java.io.PushbackReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class HashTrie
implements Map {
    private Node root;
    private int maxKeyLen;
    private int size;

    public HashTrie() {
        this.clear();
    }

    public Map.Entry getLongestMatch(CharSequence key) {
        if (this.root == null || key == null) {
            return null;
        }
        return this.root.getLongestMatch(key, 0);
    }

    public Map.Entry getLongestMatch(PushbackReader keyIn) throws IOException {
        if (this.root == null || keyIn == null) {
            return null;
        }
        return this.root.getLongestMatch(keyIn, new StringBuffer());
    }

    public int getMaxKeyLength() {
        return this.maxKeyLen;
    }

    @Override
    public void clear() {
        this.root = null;
        this.maxKeyLen = -1;
        this.size = 0;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.get(key) != null;
    }

    @Override
    public boolean containsValue(Object value) {
        return this.root != null && this.root.containsValue(value);
    }

    public Object put(CharSequence key, Object value) throws NullPointerException {
        Object old;
        if (key == null) {
            throw new NullPointerException("Null keys are not handled");
        }
        if (value == null) {
            throw new NullPointerException("Null values are not handled");
        }
        if (this.root == null) {
            this.root = new Node();
        }
        if ((old = this.root.put(key, 0, value)) != null) {
            return old;
        }
        int len = key.length();
        if (len > this.maxKeyLen) {
            this.maxKeyLen = len;
        }
        ++this.size;
        return null;
    }

    public Object put(Object key, Object value) throws NullPointerException {
        if (key == null) {
            throw new NullPointerException("Null keys are not handled");
        }
        return this.put(key.toString(), value);
    }

    public Object remove(Object key) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public void putAll(Map map) {
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry o;
            Map.Entry entry = o = iterator.next();
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public Set keySet() {
        HashSet keys = new HashSet(this.size);
        if (this.root == null) {
            return keys;
        }
        return this.root.keySet(new StringBuffer(), keys);
    }

    public Collection values() {
        ArrayList values = new ArrayList(this.size());
        if (this.root == null) {
            return values;
        }
        return this.root.values(values);
    }

    public Set entrySet() {
        HashSet entries = new HashSet(this.size());
        if (this.root == null) {
            return entries;
        }
        return this.root.entrySet(new StringBuffer(), entries);
    }

    public Object get(Object key) {
        if (this.root == null || key == null) {
            return null;
        }
        if (!(key instanceof CharSequence)) {
            return null;
        }
        return this.root.get((CharSequence)key, 0);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (!(other instanceof Map)) {
            return false;
        }
        return this.entrySet().equals(((Map)other).entrySet());
    }

    @Override
    public int hashCode() {
        return this.entrySet().hashCode();
    }

    public String toString() {
        if (this.isEmpty()) {
            return "{}";
        }
        StringBuffer sb = new StringBuffer();
        boolean first = true;
        sb.append("{ ");
        for (Object o : this.entrySet()) {
            Map.Entry entry = (Map.Entry)o;
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append(entry.toString());
        }
        sb.append(" }");
        return sb.toString();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    private static class Node {
        private Object value = null;
        private Map nextMap;

        private Node() {
        }

        private static Map newNodeMap() {
            return new HashMap();
        }

        private static Map newNodeMap(Map prev) {
            return new HashMap(prev);
        }

        void setValue(Object value) {
            this.value = value;
        }

        Node getNextNode(Character ch) {
            if (this.nextMap == null) {
                return null;
            }
            return (Node)this.nextMap.get(ch);
        }

        Node getNextNode(char ch) {
            return this.getNextNode(Wrapper.box(ch));
        }

        Object put(CharSequence key, int pos, Object addValue) {
            Node nextNode;
            if (key.length() == pos) {
                Object old = this.value;
                this.setValue(addValue);
                return old;
            }
            Character ch = Wrapper.box(key.charAt(pos));
            if (this.nextMap == null) {
                this.nextMap = Node.newNodeMap();
                nextNode = new Node();
                this.nextMap.put(ch, nextNode);
            } else {
                nextNode = (Node)this.nextMap.get(ch);
                if (nextNode == null) {
                    nextNode = new Node();
                    this.nextMap.put(ch, nextNode);
                }
            }
            return nextNode.put(key, pos + 1, addValue);
        }

        Object get(CharSequence key, int pos) {
            if (key.length() <= pos) {
                return this.value;
            }
            Node nextNode = this.getNextNode(key.charAt(pos));
            if (nextNode == null) {
                return null;
            }
            return nextNode.get(key, pos + 1);
        }

        Entry getLongestMatch(CharSequence key, int pos) {
            if (key.length() <= pos) {
                return Entry.newInstanceIfNeeded(key, this.value);
            }
            Node nextNode = this.getNextNode(key.charAt(pos));
            if (nextNode == null) {
                return Entry.newInstanceIfNeeded(key, pos, this.value);
            }
            Entry ret = nextNode.getLongestMatch(key, pos + 1);
            if (ret != null) {
                return ret;
            }
            return Entry.newInstanceIfNeeded(key, pos, this.value);
        }

        Entry getLongestMatch(PushbackReader keyIn, StringBuffer key) throws IOException {
            int c = keyIn.read();
            if (c < 0) {
                return Entry.newInstanceIfNeeded(key, this.value);
            }
            char ch = (char)c;
            int prevLen = key.length();
            key.append(ch);
            Node nextNode = this.getNextNode(ch);
            if (nextNode == null) {
                return Entry.newInstanceIfNeeded(key, this.value);
            }
            Entry ret = nextNode.getLongestMatch(keyIn, key);
            if (ret != null) {
                return ret;
            }
            key.setLength(prevLen);
            keyIn.unread(c);
            return Entry.newInstanceIfNeeded(key, this.value);
        }

        void remap() {
            if (this.nextMap == null) {
                return;
            }
            this.nextMap = Node.newNodeMap(this.nextMap);
            for (Object o : this.nextMap.values()) {
                Node node = (Node)o;
                node.remap();
            }
        }

        boolean containsValue(Object toFind) {
            if (this.value != null && toFind.equals(this.value)) {
                return true;
            }
            if (this.nextMap == null) {
                return false;
            }
            for (Object o : this.nextMap.values()) {
                Node node = (Node)o;
                if (!node.containsValue(toFind)) continue;
                return true;
            }
            return false;
        }

        Collection values(Collection values) {
            if (this.value != null) {
                values.add(this.value);
            }
            if (this.nextMap == null) {
                return values;
            }
            for (Object o : this.nextMap.values()) {
                Node node = (Node)o;
                node.values(values);
            }
            return values;
        }

        Set keySet(StringBuffer key, Set keys) {
            int len = key.length();
            if (this.value != null) {
                keys.add(key.toString());
            }
            if (this.nextMap != null && this.nextMap.size() > 0) {
                key.append('X');
                Iterator iterator = this.nextMap.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry o;
                    Map.Entry entry = o = iterator.next();
                    key.setCharAt(len, ((Character)entry.getKey()).charValue());
                    ((Node)entry.getValue()).keySet(key, keys);
                }
                key.setLength(len);
            }
            return keys;
        }

        Set entrySet(StringBuffer key, Set entries) {
            int len = key.length();
            if (this.value != null) {
                entries.add(new Entry(key.toString(), this.value));
            }
            if (this.nextMap != null && this.nextMap.size() > 0) {
                key.append('X');
                Iterator iterator = this.nextMap.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry o;
                    Map.Entry entry = o = iterator.next();
                    key.setCharAt(len, ((Character)entry.getKey()).charValue());
                    ((Node)entry.getValue()).entrySet(key, entries);
                }
                key.setLength(len);
            }
            return entries;
        }
    }

    private static class Entry
    implements Map.Entry {
        private CharSequence key;
        private Object value;

        Entry(CharSequence key, Object value) {
            this.key = key;
            this.value = value;
        }

        static Entry newInstanceIfNeeded(CharSequence key, int keyLength, Object value) {
            if (value == null || key == null) {
                return null;
            }
            if (key.length() > keyLength) {
                key = key.subSequence(0, keyLength);
            }
            return new Entry(key, value);
        }

        static Entry newInstanceIfNeeded(CharSequence key, Object value) {
            if (value == null || key == null) {
                return null;
            }
            return new Entry(key, value);
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public Object setValue(Object value) {
            throw new UnsupportedOperationException();
        }

        public boolean equals(Map.Entry other) {
            return ObjectUtil.equals(this.key, other.getKey()) && ObjectUtil.equals(this.value, other.getValue());
        }

        @Override
        public boolean equals(Object o) {
            return o instanceof Map.Entry && this.equals((Map.Entry)o);
        }

        @Override
        public int hashCode() {
            return ObjectUtil.hashCode(this.key) ^ ObjectUtil.hashCode(this.value);
        }

        public String toString() {
            return ObjectUtil.toString(this.key) + " => " + ObjectUtil.toString(this.value);
        }
    }
}

