/*
 * Decompiled with CFR 0.152.
 */
package com.tplus.transform.util;

import com.tplus.transform.util.Task;
import com.tplus.transform.util.TaskDisplayer;
import com.tplus.transform.util.TaskListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class AbstractTask
implements Task {
    private String taskName;
    private String taskGroup;
    private boolean started;
    private volatile boolean stop;
    private volatile boolean executing;
    private TaskStatusHandler statusHandler = new TaskStatusHandler();
    protected TaskDisplayer taskDisplayer = this.statusHandler;

    public AbstractTask() {
        this.taskGroup = "Unknown Task Group";
    }

    public AbstractTask(String taskName, String taskGroup) {
        this.taskName = taskName;
        this.taskGroup = taskGroup;
    }

    public String getTaskName() {
        return this.taskName;
    }

    public String getTaskGroup() {
        return this.taskGroup;
    }

    public String toString() {
        if (this.taskName != null) {
            return this.taskName;
        }
        return super.toString();
    }

    @Override
    public final Object run(TaskDisplayer taskDisplayer) throws Exception {
        this.statusHandler.addTaskListener(taskDisplayer);
        try {
            this.executing = true;
            this.started = true;
            this.statusHandler.fireTaskStarted();
            Object object = this.run();
            return object;
        }
        finally {
            this.executing = false;
            this.statusHandler.fireTaskCompleted();
        }
    }

    public Object run() throws Exception {
        return null;
    }

    public boolean isStop() {
        return this.stop;
    }

    @Override
    public boolean isExecuting() {
        return this.executing;
    }

    public boolean isStarted() {
        return this.started;
    }

    public boolean isCompleted() {
        return this.started && !this.executing && !this.stop;
    }

    @Override
    public synchronized void stop() {
        this.stop = true;
        this.notifyAll();
    }

    public synchronized void addTaskListener(TaskListener taskListener) {
        this.statusHandler.addTaskListener(taskListener);
    }

    public synchronized void addTaskListener(TaskDisplayer taskListener) {
        this.statusHandler.addTaskListener(taskListener);
    }

    public void removeTaskListener(TaskDisplayer taskDisplayer) {
        this.statusHandler.removeTaskListener(taskDisplayer);
    }

    private static class TaskStatusHandler
    implements TaskDisplayer {
        private List listeners = Collections.synchronizedList(new ArrayList());
        private int total;
        private int completed;
        private boolean indeterminate;

        private TaskStatusHandler() {
        }

        public synchronized void addTaskListener(TaskListener taskListener) {
            this.listeners.add(taskListener);
        }

        public synchronized void addTaskListener(TaskDisplayer taskListener) {
            this.listeners.add(taskListener);
            if (this.total > 0) {
                taskListener.setCompletionStatus(this.total, this.completed);
            }
            if (this.indeterminate) {
                taskListener.setIndeterminate();
            }
        }

        public synchronized void removeTaskListener(TaskDisplayer taskListener) {
            this.listeners.remove(taskListener);
        }

        @Override
        public void setIndeterminate() {
            this.indeterminate = true;
            this.onSetIndeterminate();
        }

        @Override
        public void setCompletionStatus(int total, int completed) {
            this.total = total;
            this.completed = completed;
            this.onSetCompletionStatus(total, completed);
        }

        @Override
        public void setPartialResult(Object result) {
            Object[] objects;
            for (Object object : objects = this.listeners.toArray()) {
                if (!(object instanceof TaskDisplayer)) continue;
                TaskDisplayer taskDisplayer = (TaskDisplayer)object;
                taskDisplayer.setPartialResult(result);
            }
        }

        @Override
        public void setProgressMessage(String message) {
            this.onSetProgressMessage(message);
        }

        @Override
        public void setSubtaskStatusMessage(String message) {
            this.onSetSubtaskStatusMessage(message);
        }

        @Override
        public void setCompletionMessage(String message) {
            this.onSetCompletionMessage(message);
        }

        @Override
        public void setProgressErrorMessage(String message) {
            this.onSetProgressErrorMessage(message);
        }

        void fireTaskStarted() {
            Object[] objects;
            for (Object object : objects = this.listeners.toArray()) {
                if (!(object instanceof TaskListener)) continue;
                TaskListener taskListener = (TaskListener)object;
                taskListener.onTaskStarted();
            }
        }

        void fireTaskCompleted() {
            Object[] objects;
            for (Object object : objects = this.listeners.toArray()) {
                if (!(object instanceof TaskListener)) continue;
                TaskListener taskListener = (TaskListener)object;
                taskListener.onTaskCompleted();
            }
        }

        private void onSetCompletionStatus(int total, int completed) {
            Object[] objects;
            for (Object object : objects = this.listeners.toArray()) {
                if (!(object instanceof TaskDisplayer)) continue;
                TaskDisplayer taskDisplayer = (TaskDisplayer)object;
                taskDisplayer.setCompletionStatus(total, completed);
            }
        }

        private void onSetSubtaskStatusMessage(String message) {
            Object[] objects;
            for (Object object : objects = this.listeners.toArray()) {
                if (!(object instanceof TaskDisplayer)) continue;
                TaskDisplayer taskDisplayer = (TaskDisplayer)object;
                taskDisplayer.setSubtaskStatusMessage(message);
            }
        }

        private void onSetCompletionMessage(String message) {
            Object[] objects;
            for (Object object : objects = this.listeners.toArray()) {
                if (!(object instanceof TaskDisplayer)) continue;
                TaskDisplayer taskDisplayer = (TaskDisplayer)object;
                taskDisplayer.setCompletionMessage(message);
            }
        }

        private void onSetIndeterminate() {
            Object[] objects;
            for (Object object : objects = this.listeners.toArray()) {
                if (!(object instanceof TaskDisplayer)) continue;
                TaskDisplayer taskDisplayer = (TaskDisplayer)object;
                taskDisplayer.setIndeterminate();
            }
        }

        private void onSetProgressMessage(String message) {
            Object[] objects;
            for (Object object : objects = this.listeners.toArray()) {
                if (!(object instanceof TaskDisplayer)) continue;
                TaskDisplayer taskDisplayer = (TaskDisplayer)object;
                taskDisplayer.setProgressMessage(message);
            }
        }

        private void onSetProgressErrorMessage(String message) {
            Object[] objects;
            for (Object object : objects = this.listeners.toArray()) {
                if (!(object instanceof TaskDisplayer)) continue;
                TaskDisplayer taskDisplayer = (TaskDisplayer)object;
                taskDisplayer.setProgressErrorMessage(message);
            }
        }
    }
}

